/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.tabbed;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.IDataStateListener;
import net.anwiba.commons.swing.dialog.tabbed.IDialogTab;

public abstract class AbstractDialogTab
implements IDialogTab {
    private DataState dataState = DataState.VALIDE;
    List<IDataStateListener> dataStateListeners = new ArrayList<IDataStateListener>();
    private final Icon icon;
    private final String title;
    private JComponent component;
    private IMessage currentMessage;
    private final IMessage defaultMessage;
    private Window owner;
    private final KeyListener keyListener = new KeyAdapter(){};
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialogTab.this.checkFieldValues();
        }
    };
    private final ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractDialogTab.this.checkFieldValues();
        }
    };
    private final IChangeableObjectListener changeableObjectListener = new IChangeableObjectListener(){

        public void objectChanged() {
            AbstractDialogTab.this.checkFieldValues();
        }
    };

    public AbstractDialogTab(String title, IMessage defaultMessage, Icon defaultIcon) {
        Ensure.ensureArgumentNotNull((Object)title);
        Ensure.ensureArgumentNotNull((Object)defaultIcon);
        this.title = title;
        this.defaultMessage = defaultMessage;
        this.currentMessage = defaultMessage;
        this.icon = defaultIcon;
    }

    @Override
    public void setOwnerWindow(Window owner) {
        this.owner = owner;
    }

    public Window getOwner() {
        return this.owner;
    }

    protected void setComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.setComponent(new JPanel());
        }
        return this.component;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public IMessage getMessage() {
        if (this.currentMessage == null) {
            return this.defaultMessage;
        }
        return this.currentMessage;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setCurrentMessage(IMessage message) {
        this.currentMessage = message;
    }

    @Override
    public DataState getDataState() {
        return this.dataState;
    }

    @Override
    public void addDataStateListener(IDataStateListener listener) {
        this.dataStateListeners.add(listener);
    }

    @Override
    public void removeDataStateListener(IDataStateListener listener) {
        this.dataStateListeners.remove(listener);
    }

    public void setDataState(DataState dataState) {
        if (dataState == this.dataState) {
            return;
        }
        this.dataState = dataState;
        this.fireDataStateChanged();
    }

    private void fireDataStateChanged() {
        for (IDataStateListener listener : this.dataStateListeners) {
            listener.dataStateChanged();
        }
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    protected KeyListener getKeyListener() {
        return this.keyListener;
    }

    protected ChangeListener getChangeListener() {
        return this.changeListener;
    }

    protected IChangeableObjectListener getChangeableObjectListener() {
        return this.changeableObjectListener;
    }

    @Override
    public abstract void checkFieldValues();

    protected IMessage getDefaultMessage() {
        return this.defaultMessage;
    }
}

