/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.tabbed;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.swing.dialog.tabbed.AbstractNoneEditTabbedDialogTab;
import net.anwiba.commons.swing.icons.GuiIcons;

public class TextDialogTab
extends AbstractNoneEditTabbedDialogTab {
    private static ILogger logger = Logging.getLogger(TextDialogTab.class);

    public TextDialogTab(String header, String text) {
        this(header, null, GuiIcons.INFORMATION_ICON.getLargeIcon(), header, text);
    }

    public TextDialogTab(String name, IMessage message, Icon icon, String header, String text) {
        super(name, message, icon);
        Desktop desktop;
        JPanel component = new JPanel();
        component.setLayout(new GridLayout(1, 1));
        String textString = this.createText(header, text);
        JEditorPane textArea = new JEditorPane("text/html", textString);
        textArea.setCaretPosition(0);
        textArea.setMinimumSize(new Dimension(200, 100));
        textArea.setPreferredSize(new Dimension(200, 100));
        textArea.setEditable(false);
        if (Desktop.isDesktopSupported() && textArea.getDocument() instanceof HTMLDocument && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
            textArea.addHyperlinkListener(hyperlinkEvent -> {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String description = hyperlinkEvent.getDescription();
                    logger.log(ILevel.DEBUG, "href '" + description + "'");
                    try {
                        URL url = hyperlinkEvent.getURL();
                        if (url != null) {
                            logger.log(ILevel.DEBUG, "href '" + url + "'");
                            desktop.browse(url.toURI());
                        } else if (description != null) {
                            File file = new File(description);
                            URI uri = file.getAbsoluteFile().toURI();
                            desktop.browse(uri);
                        }
                    }
                    catch (IOException | URISyntaxException exception) {
                        logger.log(ILevel.WARNING, "Couldn't browse '" + description + "'");
                        logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                    }
                }
            });
        }
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        component.add(scrollPane);
        this.setComponent(component);
    }

    private String createText(String header, String text) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        if (header != null) {
            builder.append("<H2>");
            builder.append(header);
            builder.append("</H2>");
        }
        builder.append(text);
        builder.append("</body><html>");
        return builder.toString();
    }
}

