/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.frame.view;

import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.swing.frame.IKeyActionConfiguration;
import net.anwiba.commons.swing.frame.view.AbstractView;
import net.anwiba.commons.swing.menu.AbstractMenuItemConfiguration;
import net.anwiba.commons.swing.menu.AbstractMenuItemDescription;
import net.anwiba.commons.swing.statebar.StateBarComponentConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemConfiguration;

public class ViewAdapter
extends AbstractView {
    private final JComponent component;
    private final AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] menuItemConfigurations;
    private final List<ToolBarItemConfiguration> toolBarItemConfigurations;
    private final List<StateBarComponentConfiguration> stateBarComponentConfigurations;
    private final List<IKeyActionConfiguration> keyActionConfigurations;

    public ViewAdapter(JComponent component, AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] menuItemConfigurations, ToolBarItemConfiguration[] toolBarItemConfigurations, StateBarComponentConfiguration[] stateBarComponentConfigurations, IKeyActionConfiguration[] keyActionConfigurations) {
        Ensure.ensureArgumentNotNull(menuItemConfigurations);
        Ensure.ensureArgumentNotNull((Object)toolBarItemConfigurations);
        Ensure.ensureArgumentNotNull((Object)component);
        Ensure.ensureArgumentNotNull((Object)stateBarComponentConfigurations);
        Ensure.ensureArgumentNotNull((Object)keyActionConfigurations);
        this.component = component;
        this.menuItemConfigurations = Arrays.copyOf(menuItemConfigurations, menuItemConfigurations.length);
        this.toolBarItemConfigurations = Arrays.asList(toolBarItemConfigurations);
        this.stateBarComponentConfigurations = Arrays.asList(stateBarComponentConfigurations);
        this.keyActionConfigurations = Arrays.asList(keyActionConfigurations);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public ToolBarItemConfiguration[] getToolBarItemConfigurations() {
        return this.toolBarItemConfigurations.toArray(new ToolBarItemConfiguration[this.toolBarItemConfigurations.size()]);
    }

    @Override
    public AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] getMenuItemConfigurations() {
        return this.menuItemConfigurations;
    }

    @Override
    public StateBarComponentConfiguration[] getStateBarComponentConfigurations() {
        return this.stateBarComponentConfigurations.toArray(new StateBarComponentConfiguration[this.stateBarComponentConfigurations.size()]);
    }

    @Override
    public IKeyActionConfiguration[] getKeyActionConfigurations() {
        return this.keyActionConfigurations.toArray(new IKeyActionConfiguration[this.keyActionConfigurations.size()]);
    }
}

