/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.image;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import net.anwiba.commons.graphic.ClosableGraphicsBuilder;
import net.anwiba.commons.graphic.IClosableGraphics;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerFactory;
import net.anwiba.commons.image.IImageReader;
import net.anwiba.commons.image.ImageFileFilter;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.image.ImagePanelMessages;
import net.anwiba.commons.swing.image.ImageScaleBehavior;
import net.anwiba.commons.swing.image.State;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.cancel.Canceler;

public class ImagePanel
extends JComponent
implements Scrollable {
    private static ILogger logger = Logging.getLogger(ImagePanel.class);
    private final IObjectModel<IImageContainer> imageContainerModel = new ObjectModel();
    private final IObjectModel<State> stateModel = new ObjectModel((Object)State.IDLE);
    private final IObjectModel<Throwable> exceptionModel;
    private BufferedImage thumbnail = null;
    private Thread thread = null;
    private final ImageScaleBehavior scaleBehavior;
    private Rectangle bound;
    private int maxUnitIncrement = 2;
    private final IImageReader imageReader;
    private final IImageContainerFactory imageContainerFactory;
    private final IObjectModel<IResourceReference> imageFileModel;
    private final ImageFileFilter fileFilter = new ImageFileFilter();

    public ImagePanel(IImageContainerFactory imageContainerFactory, IImageReader imageReader, IObjectModel<IResourceReference> imageFileModel) {
        this(imageContainerFactory, imageReader, imageFileModel, (IObjectModel<Throwable>)new ObjectModel(), ImageScaleBehavior.FIT);
    }

    public ImagePanel(IImageContainerFactory imageContainerFactory, IImageReader imageReader, IObjectModel<IResourceReference> imageFileModel, ImageScaleBehavior scaleUp) {
        this(imageContainerFactory, imageReader, imageFileModel, (IObjectModel<Throwable>)new ObjectModel(), scaleUp);
    }

    public ImagePanel(IImageContainerFactory imageContainerFactory, IImageReader imageReader, final IObjectModel<IResourceReference> imageFileModel, IObjectModel<Throwable> exceptionModel, ImageScaleBehavior scaleUp) {
        this.imageContainerFactory = imageContainerFactory;
        this.imageFileModel = imageFileModel;
        this.exceptionModel = exceptionModel;
        this.setAutoscrolls(true);
        this.imageReader = imageReader;
        this.scaleBehavior = scaleUp;
        this.setPreferredSize(new Dimension(100, 100));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        imageFileModel.addChangeListener(() -> {
            this.reset();
            this.load(imageFileModel, this.fileFilter);
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                ImagePanel.this.load((IObjectModel<IResourceReference>)imageFileModel, ImagePanel.this.fileFilter);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ImagePanel.this.load((IObjectModel<IResourceReference>)imageFileModel, ImagePanel.this.fileFilter);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ImagePanel.this.reset();
            }
        });
    }

    public IObjectModel<State> getStateModel() {
        return this.stateModel;
    }

    public IObjectModel<Throwable> getExceptionModel() {
        return this.exceptionModel;
    }

    protected void load(IObjectModel<IResourceReference> imageFileModel, ImageFileFilter fileFilter) {
        this.exceptionModel.set(null);
        IResourceReference imageFile = (IResourceReference)imageFileModel.get();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.isAccepted(fileFilter, imageFile)) {
            this.thread = new Thread(() -> {
                block5: {
                    try {
                        if (this.loadImage(imageFile)) {
                            GuiUtilities.invokeLater(() -> this.repaint());
                        } else {
                            BufferedImage bufferedImage = this.createErrorImage();
                            this.imageContainerModel.set((Object)this.imageContainerFactory.create(bufferedImage));
                            if (this.update()) {
                                GuiUtilities.invokeLater(() -> this.repaint());
                            }
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        this.exceptionModel.set((Object)e);
                        logger.log(ILevel.DEBUG, e.getMessage(), (Throwable)e);
                        BufferedImage bufferedImage = this.createErrorImage();
                        this.imageContainerModel.set((Object)this.imageContainerFactory.create(bufferedImage));
                        if (!this.update()) break block5;
                        GuiUtilities.invokeLater(() -> this.repaint());
                    }
                }
            }, "ImageLoader");
            this.thread.start();
        }
    }

    private BufferedImage createErrorImage() {
        final Image image = GuiIcons.ERROR_ICON.getLargeIcon().getImage();
        BufferedImage bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : new IConverter<Image, BufferedImage, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BufferedImage convert(Image input) throws RuntimeException {
                BufferedImage bufferdImage = new BufferedImage(100, 60, 2);
                Graphics2D g = bufferdImage.createGraphics();
                try {
                    g.drawImage(image, 50 - image.getWidth(null) / 2, 0, null);
                    g.setColor(Color.BLACK);
                    String errorMessage = ImagePanelMessages.ReadingFaild;
                    Rectangle2D bounds = ImagePanel.this.getFontMetrics(ImagePanel.this.getFont()).getStringBounds(errorMessage, g);
                    ((Graphics)g).drawString(errorMessage, (int)(50.0 - bounds.getWidth() / 2.0), (int)(60.0 - bounds.getHeight() - 2.0));
                }
                finally {
                    g.dispose();
                }
                return bufferdImage;
            }
        }.convert(image);
        return bufferedImage;
    }

    private boolean isAccepted(ImageFileFilter fileFilter, IResourceReference imageFile) {
        try {
            if (ResourceReferenceUtilities.isFileSystemResource((IResourceReference)imageFile)) {
                File file = ResourceReferenceUtilities.getFile((IResourceReference)imageFile);
                return file != null && file.isFile() && fileFilter.accept(file);
            }
            return imageFile != null;
        }
        catch (URISyntaxException exception) {
            this.exceptionModel.set((Object)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            this.imageContainerModel.set(null);
            this.exceptionModel.set(null);
            this.thumbnail = null;
        }
        GuiUtilities.invokeLater(() -> this.repaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadImage(IResourceReference imageFile) throws IOException {
        boolean bl;
        this.stateModel.set((Object)State.LOADING);
        try {
            ImagePanel imagePanel = this;
            synchronized (imagePanel) {
                if (this.imageContainerModel.get() == null) {
                    IImageContainer container;
                    block11: {
                        boolean bl2;
                        try {
                            container = this.imageReader.read(Canceler.DummyCanceler, imageFile);
                            if (container != null) break block11;
                            bl2 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 7, 10] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                        }
                        catch (CanceledException exception) {
                            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                            this.exceptionModel.set((Object)exception);
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 8, 10] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                            this.stateModel.set((Object)State.IDLE);
                            return bl3;
                        }
                        this.stateModel.set((Object)State.IDLE);
                        return bl2;
                    }
                    this.imageContainerModel.set((Object)container);
                }
                bl = this.update();
            }
        }
        catch (Throwable throwable) {
            this.stateModel.set((Object)State.IDLE);
            throw throwable;
        }
        this.stateModel.set((Object)State.IDLE);
        return bl;
    }

    public void reload() {
        this.imageContainerModel.set(null);
        this.thumbnail = null;
        this.load(this.imageFileModel, this.fileFilter);
    }

    private boolean update() {
        try {
            BufferedImage bufferImage;
            IImageContainer imageContainer = (IImageContainer)this.imageContainerModel.get();
            int imageWidth = imageContainer.getWidth();
            int imageHeight = imageContainer.getHeight();
            this.bound = this.imageBound(imageWidth, imageHeight);
            if (this.thumbnail != null && this.thumbnail.getWidth() == this.bound.width && this.thumbnail.getHeight() == this.bound.height) {
                return true;
            }
            this.thumbnail = bufferImage = imageContainer.fitTo(this.bound.width, this.bound.height).asBufferImage();
            return true;
        }
        catch (RuntimeException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            this.exceptionModel.set((Object)exception);
            return false;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bound != null && this.thumbnail != null) {
            try (IClosableGraphics graphic = new ClosableGraphicsBuilder((Graphics2D)g.create()).setColorRenderQuality().setStrokeControlNormalize().setAntiAliasingOn().setAlphaInterpolationQuality().setTextAntiAliasing(true).setDitheringEnabled().setRenderingQuality().build();){
                try {
                    graphic.drawImage((Image)this.thumbnail, this.bound.x, this.bound.y, (ImageObserver)this);
                }
                catch (RuntimeException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    this.exceptionModel.set((Object)exception);
                }
            }
        }
    }

    private synchronized Rectangle imageBound(int imageWidth, int imageHeight) {
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        double imageAspectRatio = (double)imageWidth / (double)imageHeight;
        double panelAspectRatio = (double)this.getWidth() / (double)this.getHeight();
        int x = 0;
        int y = 0;
        Container parent = this.getParent();
        Dimension size = parent != null ? parent.getSize() : new Dimension(256, 256);
        int width = size.width - insets.left - insets.right;
        int height = size.height - insets.top - insets.bottom;
        if (!ObjectUtilities.equals((Object)((Object)this.scaleBehavior), (Object)((Object)ImageScaleBehavior.FIT)) && imageWidth < width && imageHeight < height) {
            this.setMinimumSize(new Dimension(width, height));
            this.setPreferredSize(new Dimension(width, height));
            this.setMaximumSize(new Dimension(width, height));
            if (this.getParent() != null) {
                GuiUtilities.invokeLater(() -> this.getParent().doLayout());
            }
            x = (width - imageWidth) / 2;
            y = (height - imageHeight) / 2;
            return new Rectangle(x, y, imageWidth, imageHeight);
        }
        if (ObjectUtilities.equals((Object)((Object)this.scaleBehavior), (Object)((Object)ImageScaleBehavior.ORGIN))) {
            this.setMinimumSize(new Dimension(imageWidth, imageHeight));
            this.setPreferredSize(new Dimension(imageWidth, imageHeight));
            this.setMaximumSize(new Dimension(imageWidth, imageHeight));
            if (this.getParent() != null) {
                GuiUtilities.invokeLater(() -> this.getParent().doLayout());
            }
            return new Rectangle(0, 0, imageWidth, imageHeight);
        }
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        if (this.getParent() != null) {
            GuiUtilities.invokeLater(() -> this.getParent().doLayout());
        }
        if (imageAspectRatio < panelAspectRatio) {
            height = this.getHeight() - insets.top - insets.bottom;
            width = (int)((double)height * imageAspectRatio);
            x = (this.getWidth() - insets.left - insets.right - width) / 2;
            y = insets.top;
        } else {
            width = this.getWidth() - insets.left - insets.right;
            height = (int)((double)width / imageAspectRatio);
            x = insets.left;
            y = (this.getHeight() - insets.top - insets.bottom - height) / 2;
        }
        return new Rectangle(x, y, width, height);
    }

    public IObjectModel<IImageContainer> getImageContainerModel() {
        return this.imageContainerModel;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size;
        Container parent = this.getParent();
        Dimension dimension = size = parent != null ? parent.getSize() : new Dimension(256, 256);
        if (this.imageContainerModel.get() != null) {
            switch (this.scaleBehavior) {
                case ORGIN: {
                    IImageContainer imageContainer = (IImageContainer)this.imageContainerModel.get();
                    int imageWidth = imageContainer.getWidth();
                    int imageHeight = imageContainer.getHeight();
                    return size.width > imageWidth && size.height > imageHeight ? size : new Dimension(imageWidth, imageHeight);
                }
            }
        }
        return size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }
}

