/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.anwiba.commons.swing.layout.Anchor;
import net.anwiba.commons.swing.layout.OverlayConstraints;

public final class OverlayAnchorLayout
implements LayoutManager2 {
    private final Map<Component, OverlayConstraints> constraintsMap = new HashMap<Component, OverlayConstraints>();
    private final Map<Component, Rectangle> boundsMap = new HashMap<Component, Rectangle>();

    @Override
    public void layoutContainer(Container target) {
        if (!this.boundsMap.isEmpty()) {
            for (Component c : target.getComponents()) {
                if (this.boundsMap.containsKey(c)) {
                    c.setBounds(this.boundsMap.get(c));
                    continue;
                }
                c.setBounds(0, 0, c.getWidth(), c.getHeight());
            }
            return;
        }
        for (Component c : target.getComponents()) {
            if (this.constraintsMap.containsKey(c)) {
                OverlayConstraints constraints = this.constraintsMap.get(c);
                Rectangle rectangle = new Rectangle(this.calculateX(constraints, target, c), this.calculateY(constraints, target, c), this.calculateWidth(constraints, target, c), this.calculateHeight(constraints, target, c));
                c.setBounds(rectangle);
                this.boundsMap.put(c, rectangle);
                continue;
            }
            c.setBounds(0, 0, c.getWidth(), c.getHeight());
        }
    }

    private int calculateX(OverlayConstraints constraints, Container target, Component component) {
        Set<Anchor> anchors = constraints.getAnchors();
        Insets insets = constraints.getInsets();
        if (anchors.contains((Object)Anchor.LEFT)) {
            return Double.isNaN(constraints.getLeftFactor()) ? insets.left : (int)(constraints.getLeftFactor() * (double)target.getWidth());
        }
        if (anchors.contains((Object)Anchor.RIGHT)) {
            return target.getWidth() - (this.componentWidth(constraints, target, component) + (Double.isNaN(constraints.getRightFactor()) ? insets.right : (int)(constraints.getRightFactor() * (double)target.getWidth())));
        }
        return component.getX();
    }

    private int calculateY(OverlayConstraints constraints, Container target, Component component) {
        Set<Anchor> anchors = constraints.getAnchors();
        Insets insets = constraints.getInsets();
        if (anchors.contains((Object)Anchor.TOP)) {
            return Double.isNaN(constraints.getTopFactor()) ? insets.top : (int)(constraints.getTopFactor() * (double)target.getHeight());
        }
        if (anchors.contains((Object)Anchor.BUTTOM)) {
            return target.getHeight() - (this.componentHeight(constraints, target, component) + (Double.isNaN(constraints.getBottomFactor()) ? insets.bottom : (int)(constraints.getBottomFactor() * (double)target.getHeight())));
        }
        return component.getY();
    }

    private int calculateWidth(OverlayConstraints constraints, Container target, Component component) {
        Set<Anchor> anchors = constraints.getAnchors();
        Insets insets = constraints.getInsets();
        if (anchors.contains((Object)Anchor.LEFT) && anchors.contains((Object)Anchor.RIGHT)) {
            return target.getWidth() - (Double.isNaN(constraints.getLeftFactor()) ? insets.left : (int)(constraints.getLeftFactor() * (double)target.getWidth())) - (Double.isNaN(constraints.getRightFactor()) ? insets.right : (int)(constraints.getRightFactor() * (double)target.getWidth()));
        }
        return this.componentWidth(constraints, target, component);
    }

    private int calculateHeight(OverlayConstraints constraints, Container target, Component component) {
        Set<Anchor> anchors = constraints.getAnchors();
        if (anchors.contains((Object)Anchor.TOP) && anchors.contains((Object)Anchor.BUTTOM)) {
            Insets insets = constraints.getInsets();
            return target.getHeight() - (Double.isNaN(constraints.getTopFactor()) ? insets.top : (int)(constraints.getTopFactor() * (double)target.getHeight())) - (Double.isNaN(constraints.getBottomFactor()) ? insets.bottom : (int)(constraints.getBottomFactor() * (double)target.getHeight()));
        }
        return this.componentHeight(constraints, target, component);
    }

    private int componentWidth(OverlayConstraints constraints, Container target, Component component) {
        return Math.min(Math.max(Double.isNaN(constraints.getWidthFactor()) ? component.getWidth() : (int)((double)target.getWidth() * constraints.getWidthFactor()), component.getMinimumSize() == null ? 0 : component.getMinimumSize().width), component.getMaximumSize() == null ? Integer.MAX_VALUE : component.getMaximumSize().width);
    }

    private int componentHeight(OverlayConstraints constraints, Container target, Component component) {
        return Math.min(Math.max(Double.isNaN(constraints.getHeightFactor()) ? component.getHeight() : (int)((double)target.getHeight() * constraints.getHeightFactor()), component.getMinimumSize() == null ? 0 : component.getMinimumSize().height), component.getMaximumSize() == null ? Integer.MAX_VALUE : component.getMaximumSize().height);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        if (target.isPreferredSizeSet()) {
            return target.getPreferredSize();
        }
        return this.validateSize((i, j) -> Math.max(i, j), c -> c.getPreferredSize(), target, new Dimension());
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        if (target.isMinimumSizeSet()) {
            return target.getMinimumSize();
        }
        return this.validateSize((i, j) -> Math.max(i, j), c -> c.getMinimumSize(), target, new Dimension());
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        if (target.isMaximumSizeSet()) {
            return target.getMaximumSize();
        }
        return this.validateSize((i, j) -> Math.max(i, j), c -> c.getMaximumSize(), target, new Dimension());
    }

    private Dimension validateSize(Function function, Size sizeProvider, Container target, Dimension size) {
        Component[] components;
        for (Component component : components = target.getComponents()) {
            Dimension componentSize = sizeProvider.get(component);
            size.width = function.execute(size.width, componentSize.width);
            size.height = function.execute(size.height, componentSize.height);
        }
        Insets insets = target.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof OverlayConstraints) {
            this.addLayoutComponent(comp, (OverlayConstraints)constraints);
            return;
        }
    }

    public void addLayoutComponent(Component comp, OverlayConstraints constraints) {
        this.constraintsMap.put(comp, constraints);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.constraintsMap.containsKey(comp)) {
            this.constraintsMap.remove(comp);
        }
    }

    @Override
    public void invalidateLayout(Container target) {
        this.boundsMap.clear();
    }

    public static interface Function {
        public int execute(int var1, int var2);
    }

    public static interface Size {
        public Dimension get(Component var1);
    }
}

