/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.list.IListModel;
import net.anwiba.commons.utilities.ArrayUtilities;

public abstract class AbstractObjectListComponentModel<T>
extends AbstractListModel<T>
implements IListModel<T> {
    private static final long serialVersionUID = -5250421928985085227L;
    private final Map<T, Integer> indexByobjectMap = new HashMap<T, Integer>();
    private final List<T> objects = new ArrayList<T>();
    private final List<IChangeableListListener<T>> listModelListeners = new ArrayList<IChangeableListListener<T>>();

    public AbstractObjectListComponentModel(List<T> objects) {
        this.objects.addAll(objects);
        this.refreshIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndex() {
        AbstractObjectListComponentModel abstractObjectListComponentModel = this;
        synchronized (abstractObjectListComponentModel) {
            this.indexByobjectMap.clear();
            for (int i = 0; i < this.objects.size(); ++i) {
                this.indexByobjectMap.put(this.getObject(i), i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        AbstractObjectListComponentModel abstractObjectListComponentModel = this;
        synchronized (abstractObjectListComponentModel) {
            return this.objects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Iterable<T> objects) {
        if (!objects.iterator().hasNext()) {
            return;
        }
        int rows = 0;
        AbstractObjectListComponentModel abstractObjectListComponentModel = this;
        synchronized (abstractObjectListComponentModel) {
            rows = this.getSize();
            for (T object : objects) {
                this.indexByobjectMap.put(object, this.getSize());
                this.objects.add(object);
            }
        }
        this.fireIntervalAdded(this, rows, this.getSize() - 1);
        this.fireObjectAdded(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T ... objects) {
        if (objects.length == 0) {
            return;
        }
        int rows = 0;
        AbstractObjectListComponentModel abstractObjectListComponentModel = this;
        synchronized (abstractObjectListComponentModel) {
            rows = this.getSize();
            for (int i = 0; i < objects.length; ++i) {
                this.indexByobjectMap.put(objects[i], this.getSize());
                this.objects.add(objects[i]);
            }
        }
        this.fireIntervalAdded(this, rows, this.getSize() - 1);
        this.fireObjectAdded(Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T ... objects) {
        if (objects.length == 0) {
            return;
        }
        int[] indices = new int[]{};
        AbstractObjectListComponentModel abstractObjectListComponentModel = this;
        synchronized (abstractObjectListComponentModel) {
            indices = this.getIndicesOf(Arrays.asList(objects));
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                int index = indices[i];
                if (this.objects.remove(this.getObject(index))) continue;
                indices[i] = -1;
            }
            this.refreshIndex();
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            if (index == -1) continue;
            this.fireIntervalRemoved(this, index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ArrayList<T> objects;
        int rows = 0;
        AbstractObjectListComponentModel abstractObjectListComponentModel = this;
        synchronized (abstractObjectListComponentModel) {
            rows = this.getSize();
            if (rows == 0) {
                return;
            }
            objects = new ArrayList<T>(this.objects);
            this.objects.clear();
            this.indexByobjectMap.clear();
        }
        this.fireIntervalRemoved(this, 0, rows - 1);
        this.fireObjectRemoved(objects);
    }

    @Override
    public T getObject(int index) {
        return this.objects.get(index);
    }

    @Override
    public T getElementAt(int index) {
        return this.getObject(index);
    }

    @Override
    public int[] getIndicesOf(List<T> objects) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (T object : objects) {
            Integer index = this.indexByobjectMap.get(object);
            if (index == null) continue;
            indexes.add(index);
        }
        return ArrayUtilities.primitives((Integer[])indexes.toArray(new Integer[indexes.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListModelListener(IChangeableListListener<T> listener) {
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            this.listModelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListModelListener(IChangeableListListener<T> listener) {
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            this.listModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireObjectAdded(Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>();
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            currentListModelListeners.addAll(this.listModelListeners);
        }
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsAdded(null, objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireObjectRemoved(Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners = new ArrayList<IChangeableListListener<T>>();
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            currentListModelListeners.addAll(this.listModelListeners);
        }
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsRemoved(null, objects);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.objects.iterator();
    }
}

