/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.ICharFilter;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.primitive.IBooleanProvider;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class FieldValueController<T> {
    private boolean isDocumentListenerEnabled = true;
    private boolean isDocumentUpdateEnabled = true;
    private boolean isObjectListenerEnabled = true;
    private final PlainDocument document;
    private final IObjectModel<T> model;
    private final IConverter<String, T, RuntimeException> toObjectConverter;
    private final IConverter<T, String, RuntimeException> toStringConverter;
    private final IObjectModel<IValidationResult> validStateModel;
    private final IValidator<String> validator;
    private final IBooleanProvider isEditableProvider;
    final IConverter<PlainDocument, String, RuntimeException> documentToStringConverter = new IConverter<PlainDocument, String, RuntimeException>(){

        public String convert(PlainDocument plainDocument) throws RuntimeException {
            try {
                String text = plainDocument.getText(0, plainDocument.getLength());
                if (FieldValueController.this.characterFilter == null) {
                    return text;
                }
                StringBuilder builder = new StringBuilder();
                for (char character : text.toCharArray()) {
                    if (!FieldValueController.this.characterFilter.accept(character)) continue;
                    builder.append(character);
                }
                return builder.toString();
            }
            catch (BadLocationException exception) {
                return "";
            }
        }
    };
    private final ICharFilter characterFilter;

    public FieldValueController(PlainDocument document, IObjectModel<T> model, IBooleanProvider isEditableProvider, IConverter<String, T, RuntimeException> toObjectConverter, IConverter<T, String, RuntimeException> toStringConverter, IObjectModel<IValidationResult> validStateModel, ICharFilter characterFilter, IValidator<String> validator) {
        this.document = document;
        this.model = model;
        this.isEditableProvider = isEditableProvider;
        this.toObjectConverter = toObjectConverter;
        this.toStringConverter = toStringConverter;
        this.validStateModel = validStateModel;
        this.characterFilter = characterFilter;
        this.validator = validator;
    }

    public synchronized void documentChanged() {
        if (this.isEditableProvider.isTrue() && this.isDocumentListenerEnabled) {
            try {
                this.isDocumentUpdateEnabled = false;
                this.updateModel();
            }
            finally {
                this.isDocumentUpdateEnabled = true;
            }
        }
    }

    public void modelChanged() {
        if (this.isObjectListenerEnabled) {
            this.updateFieldText();
        }
    }

    public void format() {
        try {
            this.isObjectListenerEnabled = false;
            if (((IValidationResult)this.validStateModel.get()).isValid()) {
                String formatedText = (String)this.toStringConverter.convert(this.model.get());
                if (this.getText().equals(formatedText)) {
                    return;
                }
                this.setText(formatedText);
            }
        }
        finally {
            this.isObjectListenerEnabled = true;
        }
    }

    private synchronized void updateModel() {
        String textValue = (String)this.documentToStringConverter.convert((Object)this.document);
        try {
            IValidationResult validationResult = this.validator.validate((Object)textValue);
            if (validationResult.isValid()) {
                this.model.set(this.toObjectConverter.convert((Object)textValue));
            }
            this.validStateModel.set((Object)validationResult);
        }
        catch (Exception exception) {
            String unsupportedValueMessage = "Unsupported input '" + textValue + "'";
            String message = exception.getMessage() == null ? unsupportedValueMessage : unsupportedValueMessage + "," + exception.getMessage();
            AbstractObjectTextField.logger.log(ILevel.ERROR, message, (Throwable)exception);
            this.validStateModel.set((Object)IValidationResult.inValid((String)message));
        }
    }

    private synchronized void updateFieldText() {
        String currentText;
        Object value = this.model.get();
        String textValue = (String)this.toStringConverter.convert(value);
        if (Objects.equals(textValue, currentText = (String)this.documentToStringConverter.convert((Object)this.document))) {
            return;
        }
        IValidationResult validationResult = this.validator.validate((Object)textValue);
        if (validationResult.isValid()) {
            this.setText(textValue);
        } else if (value == null) {
            this.setText("");
        }
        this.validStateModel.set((Object)validationResult);
    }

    public synchronized String getText() {
        return (String)this.documentToStringConverter.convert((Object)this.document);
    }

    public synchronized void setText(String textValue) {
        block5: {
            try {
                if (!this.isDocumentUpdateEnabled) break block5;
                try {
                    this.isDocumentListenerEnabled = false;
                    this.document.remove(0, this.document.getLength());
                }
                finally {
                    this.isDocumentListenerEnabled = true;
                }
                this.document.insertString(0, textValue, null);
            }
            catch (BadLocationException exception) {
                throw new UnreachableCodeReachedException((Throwable)exception);
            }
        }
    }
}

