/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.lang.object.IObjectToStringConverter;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.IObjectComponent;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.JTextComponentUtilities;

public class ObjectComponentBuilder<T> {
    private static ILogger logger = Logging.getLogger(ObjectComponentBuilder.class);
    private IObjectToStringConverter<T> converter = object -> (String)Optional.of((Object)object).convert(o -> o.toString()).getOr(() -> "");
    private IObjectModel<T> model = new ObjectModel();
    private Color backgroundColor;

    public ObjectComponentBuilder<T> setModel(IObjectModel<T> model) {
        this.model = model;
        return this;
    }

    public ObjectComponentBuilder<T> setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ObjectComponentBuilder<T> setToStringConverter(IObjectToStringConverter<T> converter) {
        this.converter = converter;
        return this;
    }

    public IObjectComponent<T> build() {
        return new ObjectComponent<T>(this.model, this.converter, this.backgroundColor);
    }

    public static final class ObjectComponent<T>
    implements IObjectComponent<T> {
        private final IObjectModel<T> model;
        private final IObjectToStringConverter<T> converter;
        private final Color backgroundColor;

        public ObjectComponent(IObjectModel<T> model, IObjectToStringConverter<T> converter, Color backgroundColor) {
            this.model = model;
            this.converter = converter;
            this.backgroundColor = backgroundColor;
        }

        @Override
        public JComponent getComponent() {
            JEditorPane area = new JEditorPane("text/html", "<html><body>" + this.converter.toString(this.model.get()) + "<body></html>");
            Optional.of((Object)this.backgroundColor).consume(c -> area.setBackground((Color)c));
            area.setEditable(false);
            area.setCaretPosition(0);
            JTextComponentUtilities.enableHyperlinks(area);
            this.model.addChangeListener(() -> GuiUtilities.invokeLater(() -> {
                area.setText("<html><body>" + this.converter.toString(this.model.get()) + "<body></html>");
                area.setCaretPosition(0);
            }));
            return area;
        }

        @Override
        public IObjectReceiver<T> getReciever() {
            return this.model;
        }
    }
}

