/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.numeric;

import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.numeric.FloatField;
import net.anwiba.commons.swing.object.numeric.FloatObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class FloatFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<Float, FloatObjectFieldConfigurationBuilder, FloatFieldBuilder> {
    public FloatFieldBuilder() {
        super(new FloatObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Float> create(IObjectFieldConfiguration<Float> configuration) {
        return new FloatField(configuration);
    }

    public FloatFieldBuilder addModuloSpinnerActions(int m, float step) {
        return this.addModuloSpinnerActions(m, step, 250, 100);
    }

    public FloatFieldBuilder addModuloSpinnerActions(int m, float step, int initialDelay, int delay) {
        Function<Float, Float> minus = input -> (Float)Optional.of((Object)input).convert(v1 -> Float.valueOf((v1.floatValue() - step) % (float)m)).convert(v2 -> Float.valueOf(v2.floatValue() < 0.0f ? v2.floatValue() + (float)m : v2.floatValue())).convert(v2 -> Float.valueOf(v2.floatValue() >= (float)m ? v2.floatValue() - (float)m : v2.floatValue())).getOr(() -> Float.valueOf((float)m - step));
        Function<Float, Boolean> minusEnabler = input -> true;
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Float, Float> add = input -> (Float)Optional.of((Object)input).convert(v1 -> Float.valueOf((v1.floatValue() + step) % (float)m)).convert(v2 -> Float.valueOf(v2.floatValue() < 0.0f ? v2.floatValue() + (float)m : v2.floatValue())).convert(v2 -> Float.valueOf(v2.floatValue() >= (float)m ? v2.floatValue() - (float)m : v2.floatValue())).getOr(() -> Float.valueOf(0.0f));
        Function<Float, Boolean> addEnabler = input -> true;
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    public FloatFieldBuilder addSpinnerActions(float step) {
        return this.addSpinnerActions(-3.4028235E38f, Float.MAX_VALUE, step, 250, 100);
    }

    public FloatFieldBuilder addSpinnerActions(float minimum, float maximum, float step) {
        return this.addSpinnerActions(minimum, maximum, step, 250, 100);
    }

    public FloatFieldBuilder addSpinnerActions(float minimum, float maximum, float step, int initialDelay, int delay) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Float)converter.convert(v1)).convert(v2 -> this.isValid((Float)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Float, Float> minus = input -> (Float)Optional.of((Object)input).convert(v1 -> Float.valueOf(v1.floatValue() - step)).convert(v2 -> Float.valueOf(v2.floatValue() < minimum ? minimum : v2.floatValue())).convert(v3 -> Float.valueOf(v3.floatValue() > maximum ? maximum : v3.floatValue())).getOr(() -> Float.valueOf(maximum));
        Function<Float, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.floatValue() > minimum && minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Float, Float> add = input -> (Float)Optional.of((Object)input).convert(v1 -> Float.valueOf(v1.floatValue() + step)).convert(v2 -> Float.valueOf(v2.floatValue() < minimum ? minimum : v2.floatValue())).convert(v3 -> Float.valueOf(v3.floatValue() > maximum ? maximum : v3.floatValue())).getOr(() -> Float.valueOf(minimum));
        Function<Float, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.floatValue() < maximum && minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    private IValidationResult isValid(Float value, float minimum, float maximum) {
        return value.floatValue() < minimum ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value.floatValue() > maximum ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

