/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.numeric;

import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.numeric.LongField;
import net.anwiba.commons.swing.object.numeric.LongObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class LongFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<Long, LongObjectFieldConfigurationBuilder, LongFieldBuilder> {
    public LongFieldBuilder() {
        super(new LongObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Long> create(IObjectFieldConfiguration<Long> configuration) {
        return new LongField(configuration);
    }

    public LongFieldBuilder addSliderActions(long minimum, long maximum, long step) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Long)converter.convert(v1)).convert(v2 -> this.isValid((Long)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Long, Long> minus = input -> (Long)Optional.of((Object)input).convert(v1 -> v1 - step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> maximum);
        Function<Long, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 > minimum && minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, 250, 100));
        Function<Long, Long> add = input -> (Long)Optional.of((Object)input).convert(v1 -> v1 + step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> minimum);
        Function<Long, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 < maximum && minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, 250, 100));
        return this;
    }

    public LongFieldBuilder addSpinnerActions(long minimum, long maximum, long step) {
        return this.addSpinnerActions(minimum, maximum, step, 250, 100);
    }

    public LongFieldBuilder addSpinnerActions(long minimum, long maximum, long step, int initialDelay, int delay) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Long)converter.convert(v1)).convert(v2 -> this.isValid((Long)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Long, Long> minus = input -> (Long)Optional.of((Object)input).convert(v1 -> v1 - step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> maximum);
        Function<Long, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 > minimum & minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Long, Long> add = input -> (Long)Optional.of((Object)input).convert(v1 -> v1 + step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> minimum);
        Function<Long, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 < maximum & minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    public IValidationResult isValid(Long value, long minimum, long maximum) {
        return value < minimum ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value > maximum ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

