/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.numeric;

import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.swing.object.AbstractObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class LongObjectFieldConfigurationBuilder
extends AbstractObjectFieldConfigurationBuilder<Long, LongObjectFieldConfigurationBuilder> {
    public LongObjectFieldConfigurationBuilder() {
        super(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.valid();
                }
                try {
                    Long.valueOf(value);
                    return IValidationResult.valid();
                }
                catch (Throwable exception) {
                    return IValidationResult.inValid((String)exception.getLocalizedMessage());
                }
            }
        }, new IConverter<String, Long, RuntimeException>(){

            public Long convert(String number) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)number)) {
                    return null;
                }
                return Long.valueOf(number);
            }
        }, new IConverter<Long, String, RuntimeException>(){

            public String convert(Long number) {
                if (number == null) {
                    return null;
                }
                return number.toString();
            }
        });
    }
}

