/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.numeric;

import java.math.BigDecimal;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.swing.object.AbstractObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class NumberFieldConfigurationBuilder
extends AbstractObjectFieldConfigurationBuilder<Number, NumberFieldConfigurationBuilder> {
    public NumberFieldConfigurationBuilder() {
        super(new IValidator<String>(){

            public IValidationResult validate(String value) {
                return IValidationResult.valid();
            }
        }, new IConverter<String, Number, RuntimeException>(){

            public Number convert(String number) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)number)) {
                    return null;
                }
                return new BigDecimal(number);
            }
        }, new IConverter<Number, String, RuntimeException>(){

            public String convert(Number number) {
                if (number == null) {
                    return null;
                }
                return number.toString();
            }
        });
    }
}

