/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.numeric;

import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.swing.object.AbstractObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class ShortObjectFieldConfigurationBuilder
extends AbstractObjectFieldConfigurationBuilder<Short, ShortObjectFieldConfigurationBuilder> {
    public ShortObjectFieldConfigurationBuilder() {
        super(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.valid();
                }
                try {
                    Short.valueOf(value);
                    return IValidationResult.valid();
                }
                catch (Throwable exception) {
                    return IValidationResult.inValid((String)exception.getLocalizedMessage());
                }
            }
        }, new IConverter<String, Short, RuntimeException>(){

            public Short convert(String number) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)number)) {
                    return null;
                }
                return Short.valueOf(number);
            }
        }, new IConverter<Short, String, RuntimeException>(){

            public String convert(Short number) {
                if (number == null) {
                    return null;
                }
                return number.toString();
            }
        });
    }
}

