/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.temporal;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.temporal.DateField;
import net.anwiba.commons.swing.object.temporal.DateObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class DateFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<Date, DateObjectFieldConfigurationBuilder, DateFieldBuilder> {
    public DateFieldBuilder() {
        super(new DateObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Date> create(IObjectFieldConfiguration<Date> configuration) {
        return new DateField(configuration);
    }

    public DateFieldBuilder addSliderActions(Date minimum, Date maximum, long step, TemporalUnit unit) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Date)converter.convert(v1)).convert(v2 -> this.isValid((Date)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Date, Date> add = input -> (Date)Optional.of((Object)input).convert(v1 -> {
            LocalDateTime ldt = LocalDateTime.ofInstant(v1.toInstant(), ZoneId.systemDefault());
            LocalDateTime plus = ldt.plus(step, unit);
            return Date.from(plus.atZone(ZoneId.systemDefault()).toInstant());
        }).convert(v2 -> v2.getTime() < minimum.getTime() ? minimum : v2).convert(v3 -> v3.getTime() > maximum.getTime() ? maximum : v3).getOr(() -> minimum);
        Function<Date, Date> minus = input -> (Date)Optional.of((Object)input).convert(v1 -> {
            LocalDateTime ldt = LocalDateTime.ofInstant(v1.toInstant(), ZoneId.systemDefault());
            LocalDateTime result = ldt.minus(step, unit);
            return Date.from(result.atZone(ZoneId.systemDefault()).toInstant());
        }).convert(v2 -> v2.getTime() < minimum.getTime() ? minimum : v2).convert(v3 -> v3.getTime() > maximum.getTime() ? maximum : v3).getOr(() -> maximum);
        Function<Date, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.getTime() > minimum.getTime() && minimum.getTime() < maximum.getTime()).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, 250, 100));
        Function<Date, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.getTime() < maximum.getTime() && minimum.getTime() < maximum.getTime()).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, 250, 100));
        return this;
    }

    public IValidationResult isValid(Date value, Date minimum, Date maximum) {
        return value.getTime() < minimum.getTime() ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value.getTime() > maximum.getTime() ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

