/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.temporal;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.temporal.DurationField;
import net.anwiba.commons.swing.object.temporal.DurationFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class DurationFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<Duration, DurationFieldConfigurationBuilder, DurationFieldBuilder> {
    public DurationFieldBuilder() {
        super(new DurationFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Duration> create(IObjectFieldConfiguration<Duration> configuration) {
        return new DurationField(configuration);
    }

    public DurationFieldBuilder addSliderActions(Duration minimum, Duration maximum, long step, TemporalUnit unit) {
        return this.addSliderActions(minimum, maximum, step, (IObjectModel<TemporalUnit>)new ObjectModel((Object)unit));
    }

    public DurationFieldBuilder addSliderActions(Duration minimum, Duration maximum, long step, IObjectModel<TemporalUnit> unit) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Duration)converter.convert(v1)).convert(v2 -> this.isValid((Duration)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Duration, Duration> add = input -> (Duration)Optional.of((Object)input).convert(v1 -> v1.plus(step, (TemporalUnit)unit.get())).convert(v2 -> v2.compareTo(minimum) < 0 ? minimum : v2).convert(v3 -> v3.compareTo(maximum) > 0 ? maximum : v3).getOr(() -> minimum);
        Function<Duration, Duration> minus = input -> (Duration)Optional.of((Object)input).convert(v1 -> v1.minus(step, (TemporalUnit)unit.get())).convert(v2 -> v2.compareTo(minimum) < 0 ? minimum : v2).convert(v3 -> v3.compareTo(maximum) > 0 ? maximum : v3).getOr(() -> maximum);
        Function<Duration, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.compareTo(minimum) > 0 && minimum.compareTo(maximum) < 0).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, 250, 100));
        Function<Duration, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.compareTo(maximum) < 0 && minimum.compareTo(maximum) < 0).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, 250, 100));
        return this;
    }

    public IValidationResult isValid(Duration value, Duration minimum, Duration maximum) {
        return value.compareTo(minimum) < 0 ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value.compareTo(maximum) > 0 ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

