/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object.temporal;

import java.time.LocalTime;
import java.time.temporal.TemporalUnit;
import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.temporal.LocalTimeField;
import net.anwiba.commons.swing.object.temporal.LocalTimeObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class LocalTimeFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<LocalTime, LocalTimeObjectFieldConfigurationBuilder, LocalTimeFieldBuilder> {
    public LocalTimeFieldBuilder() {
        super(new LocalTimeObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<LocalTime> create(IObjectFieldConfiguration<LocalTime> configuration) {
        return new LocalTimeField(configuration);
    }

    public LocalTimeFieldBuilder addSliderActions(LocalTime minimum, LocalTime maximum, long step, TemporalUnit unit) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (LocalTime)converter.convert(v1)).convert(v2 -> this.isValid((LocalTime)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<LocalTime, LocalTime> add = input -> (LocalTime)Optional.of((Object)input).convert(v1 -> v1.plus(step, unit)).convert(v2 -> v2.compareTo(minimum) < 0 ? minimum : v2).convert(v3 -> v3.compareTo(maximum) > 0 ? maximum : v3).getOr(() -> minimum);
        Function<LocalTime, LocalTime> minus = input -> (LocalTime)Optional.of((Object)input).convert(v1 -> v1.minus(step, unit)).convert(v2 -> v2.compareTo(minimum) < 0 ? minimum : v2).convert(v3 -> v3.compareTo(maximum) > 0 ? maximum : v3).getOr(() -> maximum);
        Function<LocalTime, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.compareTo(minimum) > 0 && minimum.compareTo(maximum) < 0).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, 250, 100));
        Function<LocalTime, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.compareTo(maximum) < 0 && minimum.compareTo(maximum) < 0).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, 250, 100));
        return this;
    }

    public IValidationResult isValid(LocalTime value, LocalTime minimum, LocalTime maximum) {
        return value.compareTo(minimum) < 0 ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value.compareTo(maximum) > 0 ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

