/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.Color;
import net.anwiba.commons.preferences.IPreferences;

public class ColorPreference {
    public static final String NAME = "color";
    private static final String ALPHA = "ALPHA";
    private static final String BLUE = "BLUE";
    private static final String GREEN = "GREEN";
    private static final String RED = "RED";
    private final IPreferences preferences;

    public ColorPreference(IPreferences preferences) {
        this.preferences = preferences;
    }

    public Color getColor() {
        int r = this.preferences.getInt(RED, 0);
        int g = this.preferences.getInt(GREEN, 0);
        int b = this.preferences.getInt(BLUE, 0);
        int a = this.preferences.getInt(ALPHA, 0);
        return new Color(r, g, b, a);
    }

    public void setColor(Color color) {
        this.preferences.setInt(RED, color.getRed());
        this.preferences.setInt(GREEN, color.getGreen());
        this.preferences.setInt(BLUE, color.getBlue());
        this.preferences.setInt(ALPHA, color.getAlpha());
        this.preferences.flush();
    }
}

