/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.Rectangle;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.preference.BoundsPreference;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowState;

public class WindowPreferences
implements IWindowPreferences {
    private final BoundsPreference boundsPreference;
    private final IPreferences preferences;

    public WindowPreferences(IPreferences preferences) {
        this.preferences = preferences;
        this.boundsPreference = new BoundsPreference((IPreferences)(preferences == null ? new DummyPreferences(new String[0]) : preferences.node(new String[]{"bounds"})));
    }

    @Override
    public Rectangle getBounds() {
        return this.boundsPreference.getRectangle();
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.boundsPreference.setRectangle(bounds);
    }

    @Override
    public void setIconified() {
        this.preferences.put("state", WindowState.ICONIFIED.name());
    }

    @Override
    public void setMaximized() {
        this.preferences.put("state", WindowState.MAXIMIZED.name());
    }

    @Override
    public void setNormal() {
        this.preferences.remove("state");
    }

    @Override
    public WindowState getState() {
        return (WindowState)((Object)Optional.of((Object)this.preferences.get("state", null)).convert(v -> WindowState.valueOf(v)).getOr(() -> WindowState.NORMAL));
    }
}

