/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowState;

public final class WindowPrefereneceUpdatingListener
extends WindowAdapter
implements ComponentListener {
    private final Window window;
    private final IWindowPreferences preferences;
    private boolean isVisible = false;
    private Rectangle rectangle = new Rectangle();
    private WindowState windowState = WindowState.NORMAL;

    public WindowPrefereneceUpdatingListener(Window window, IWindowPreferences windowPreferences) {
        this.window = window;
        this.preferences = windowPreferences;
    }

    @Override
    public synchronized void componentResized(ComponentEvent e) {
        this.update();
    }

    @Override
    public synchronized void componentMoved(ComponentEvent e) {
        this.update();
    }

    private void update() {
        if (!this.isVisible || Objects.equals((Object)WindowState.NORMAL, (Object)this.windowState) && this.window.getBounds().equals(this.rectangle)) {
            return;
        }
        if (this.window instanceof Frame) {
            Frame frame = (Frame)this.window;
            int state = frame.getExtendedState();
            switch (state) {
                case 6: {
                    this.windowState = WindowState.MAXIMIZED;
                    this.preferences.setMaximized();
                    break;
                }
                case 1: {
                    this.windowState = WindowState.ICONIFIED;
                    this.preferences.setIconified();
                    break;
                }
                default: {
                    this.windowState = WindowState.NORMAL;
                    this.preferences.setNormal();
                }
            }
            if (state != 0) {
                return;
            }
        }
        this.rectangle = this.window.getBounds();
        this.preferences.setBounds(this.rectangle);
    }

    @Override
    public synchronized void componentShown(ComponentEvent e) {
        this.isVisible = true;
        if (this.window instanceof Frame) {
            Frame frame = (Frame)this.window;
            int state = frame.getExtendedState();
            switch (state) {
                case 6: {
                    this.windowState = WindowState.MAXIMIZED;
                    break;
                }
                case 1: {
                    this.windowState = WindowState.ICONIFIED;
                    break;
                }
                default: {
                    this.windowState = WindowState.NORMAL;
                }
            }
        }
        this.rectangle = this.window.getBounds();
    }

    @Override
    public synchronized void componentHidden(ComponentEvent e) {
        this.isVisible = false;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.window.removeComponentListener(this);
        this.window.removeWindowListener(this);
    }
}

