/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class WrappedTableModel
implements TableModel,
Serializable {
    private final EventListenerList listenerList = new EventListenerList();
    private final IObjectModel<TableModel> model = new ObjectModel();
    private final TableModelListener delegatingTableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            WrappedTableModel.this.fireTableChanged(new TableModelEvent(WrappedTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType()));
        }
    };

    public WrappedTableModel(TableModel tableModel) {
        this.model.set((Object)tableModel);
        tableModel.addTableModelListener(this.delegatingTableModelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrap(TableModel tableModel) {
        IObjectModel<TableModel> iObjectModel = this.model;
        synchronized (iObjectModel) {
            if (this.model.get() == tableModel) {
                return;
            }
            this.model.optional().consume(o -> o.removeTableModelListener(this.delegatingTableModelListener));
            this.model.set((Object)tableModel);
            this.model.optional().consume(o -> o.addTableModelListener(this.delegatingTableModelListener));
        }
        GuiUtilities.invokeLater(() -> {
            this.fireTableChanged(new TableModelEvent(this, -1));
            this.fireTableChanged(new TableModelEvent(this));
        });
    }

    public <T extends TableModel> T unwrap(Class<T> clazz) {
        return (T)((TableModel)this.model.optional().accept(clazz::isInstance).getOrThrow(() -> new IllegalArgumentException()));
    }

    public boolean isWrapperFor(Class<? extends TableModel> clazz) {
        return this.model.optional().accept(o -> clazz.isInstance(o)).isAccepted();
    }

    @Override
    public int getRowCount() {
        return (Integer)this.model.optional().convert(TableModel::getRowCount).getOr(() -> 0);
    }

    @Override
    public int getColumnCount() {
        return (Integer)this.model.optional().convert(TableModel::getColumnCount).getOr(() -> 1);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return (String)this.model.optional().convert(o -> o.getColumnName(columnIndex)).getOr(() -> columnIndex == 0 ? "empty" : this.generateColumnName(columnIndex));
    }

    private String generateColumnName(int columnIndex) {
        Object result = "";
        while (columnIndex >= 0) {
            result = (char)((char)(columnIndex % 26) + 65) + (String)result;
            columnIndex = columnIndex / 26 - 1;
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return (Class)this.model.optional().convert(o -> o.getColumnClass(columnIndex)).getOr(() -> Object.class);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.optional().accept(o -> o.isCellEditable(rowIndex, columnIndex)).isAccepted();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.optional().convert(o -> o.getValueAt(rowIndex, columnIndex)).getOr(() -> null);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.model.optional().consume(o -> o.setValueAt(aValue, rowIndex, columnIndex));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
            continue;
        }
    }
}

