/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.listener;

import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISortedRowMapper;

public final class TableSelectionListener<T>
implements ListSelectionListener {
    private final IObjectTableModel<T> tableModel;
    private final ListSelectionModel tableSelectionModel;
    private final ISelectionModel<T> objectSelectionModel;
    private final ISortedRowMapper sortedRowMapper;

    public TableSelectionListener(IObjectTableModel<T> tableModel, ListSelectionModel tableSelectionModel, ISelectionModel<T> objectSelectionModel, ISortedRowMapper sortedRowMapper) {
        this.tableModel = tableModel;
        this.tableSelectionModel = tableSelectionModel;
        this.objectSelectionModel = objectSelectionModel;
        this.sortedRowMapper = sortedRowMapper;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this.tableSelectionModel.isSelectionEmpty()) {
            this.objectSelectionModel.removeAllSelectedObjects();
            return;
        }
        HashSet<Integer> indeces = new HashSet<Integer>();
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = this.tableSelectionModel.getMinSelectionIndex(); i <= this.tableSelectionModel.getMaxSelectionIndex(); ++i) {
            if (!this.tableSelectionModel.isSelectedIndex(i)) continue;
            indeces.add(i);
        }
        for (Integer index : indeces) {
            objects.add(this.tableModel.get(this.sortedRowMapper.getModelIndex(index)));
        }
        this.objectSelectionModel.setSelectedObjects(objects);
    }
}

