/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.renderer;

import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.anwiba.commons.lang.object.ObjectUtilities;

public class NumberTableCellRenderer
extends DefaultTableCellRenderer {
    private final NumberFormat format;

    public NumberTableCellRenderer() {
        this((String)null);
    }

    public NumberTableCellRenderer(String pattern) {
        this.format = pattern != null ? new DecimalFormat(pattern) : null;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setHorizontalAlignment(4);
        if (value instanceof Number) {
            Number number = (Number)value;
            this.setText(this.format != null ? this.format.format(number) : number.toString());
            return this;
        }
        this.setText(ObjectUtilities.toString((Object)value));
        return this;
    }
}

