/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.renderer;

import java.awt.Component;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.anwiba.commons.swing.ui.DateUi;
import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.AngleFormat;
import net.anwiba.commons.utilities.time.LocalDateTimeUtilities;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;

public class ObjectTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    DateUi dateUi = new DateUi();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof ZonedDateTime) {
            ZonedDateTime dateTime = (ZonedDateTime)value;
            this.setText(ZonedDateTimeUtilities.toString((ZonedDateTime)dateTime));
            this.setHorizontalAlignment(4);
            return this;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)value;
            this.setText(LocalDateTimeUtilities.toString((LocalDateTime)dateTime));
            this.setHorizontalAlignment(4);
            return this;
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            this.setText(LocalDateTimeUtilities.toString((LocalDate)date));
            this.setHorizontalAlignment(4);
            return this;
        }
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            this.setText(LocalDateTimeUtilities.toString((LocalTime)time));
            this.setHorizontalAlignment(4);
            return this;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            this.setText(this.dateUi.getText(date));
            this.setHorizontalAlignment(4);
            return this;
        }
        this.setIcon(null);
        if (value instanceof Angle) {
            this.setHorizontalAlignment(4);
            this.setText(new AngleFormat().format(value));
            return this;
        }
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
            if (value instanceof Double || value instanceof Float) {
                this.setText(String.format("%.2f", value));
                return this;
            }
            return this;
        }
        this.setHorizontalAlignment(2);
        return this;
    }
}

