/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.toolbar;

import java.io.Serializable;
import java.util.Comparator;
import javax.swing.JToolBar;
import net.anwiba.commons.swing.toolbar.IToolBarComponentRegistry;
import net.anwiba.commons.swing.toolbar.ToolBarConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarDescription;
import net.anwiba.commons.swing.toolbar.ToolBarItemConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemDescription;
import net.anwiba.commons.swing.toolbar.ToolBarItemGroupConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemGroupDescription;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class ToolBarManager
implements IToolBarComponentRegistry {
    private final KeyValueRegistry<ToolBarDescription, ToolBarConfiguration> registry = new KeyValueRegistry();
    final Comparator<ToolBarDescription> comparator = new ToolBarDescriptionComparator();

    public synchronized JToolBar[] getJToolBars() {
        ToolBarConfiguration[] toolBars = (ToolBarConfiguration[])this.registry.getItems(this.comparator, ToolBarDescription.class, ToolBarConfiguration.class);
        JToolBar[] jtoolBars = new JToolBar[toolBars.length];
        for (int i = 0; i < jtoolBars.length; ++i) {
            jtoolBars[i] = toolBars[i].getJToolBar();
        }
        return jtoolBars;
    }

    private synchronized void addConfiguration(ToolBarItemConfiguration toolBarItemConfiguration) {
        ToolBarItemGroupDescription toolBarGroupDescription;
        ToolBarItemGroupConfiguration toolBarGroup;
        ToolBarDescription toolBarDescription = ((ToolBarItemDescription)toolBarItemConfiguration.getDescription()).getToolBarDescription();
        ToolBarConfiguration toolBarConfiguration = (ToolBarConfiguration)this.registry.get((Object)toolBarDescription);
        if (toolBarConfiguration == null) {
            toolBarConfiguration = new ToolBarConfiguration(toolBarDescription);
            this.registry.register((Object)toolBarDescription, (Object)toolBarConfiguration);
        }
        if ((toolBarGroup = toolBarConfiguration.get(toolBarGroupDescription = ((ToolBarItemDescription)toolBarItemConfiguration.getDescription()).getToolBarGroupDescription())) == null) {
            toolBarGroup = new ToolBarItemGroupConfiguration(toolBarGroupDescription);
            toolBarConfiguration.add(toolBarGroup);
        }
        toolBarGroup.add(toolBarItemConfiguration);
    }

    @Override
    public synchronized void add(ToolBarItemConfiguration ... toolBarItems) {
        for (ToolBarItemConfiguration toolBarItem : toolBarItems) {
            this.addConfiguration(toolBarItem);
        }
    }

    private synchronized void remove(ToolBarItemConfiguration toolBarItem) {
        ToolBarDescription toolBarDescription = ((ToolBarItemDescription)toolBarItem.getDescription()).getToolBarDescription();
        ToolBarConfiguration toolBar = (ToolBarConfiguration)this.registry.get((Object)toolBarDescription);
        if (toolBar == null) {
            return;
        }
        ToolBarItemGroupDescription toolBarGroupDescription = ((ToolBarItemDescription)toolBarItem.getDescription()).getToolBarGroupDescription();
        ToolBarItemGroupConfiguration toolBarGroup = toolBar.get(toolBarGroupDescription);
        if (toolBarGroup == null) {
            return;
        }
        toolBarGroup.remove(toolBarItem);
        if (toolBarGroup.isEmpty()) {
            toolBar.remove(toolBarGroup);
        }
        if (toolBar.isEmpty()) {
            this.registry.remove((Object)toolBarDescription);
        }
    }

    public synchronized void remove(ToolBarItemConfiguration[] toolBarItems) {
        for (ToolBarItemConfiguration toolBarItem : toolBarItems) {
            this.remove(toolBarItem);
        }
    }

    public static final class ToolBarDescriptionComparator
    implements Comparator<ToolBarDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(ToolBarDescription o1, ToolBarDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

