/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.transferable;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.anwiba.commons.swing.transferable.ITransferableFactories;
import net.anwiba.commons.swing.transferable.ITransferableFactory;
import net.anwiba.commons.swing.transferable.TransferableFactories;

public class TransferableFactory {
    private final ITransferableFactories transferableFactories;

    public TransferableFactory(Collection<ITransferableFactory> transferableFactories) {
        this(new TransferableFactories(transferableFactories));
    }

    public TransferableFactory(ITransferableFactories transferableFactories) {
        this.transferableFactories = transferableFactories;
    }

    public Transferable create(JComponent c) {
        Object userObject = this.getObject(c);
        return (Transferable)this.transferableFactories.getApplicable(userObject).convert(f -> f.create(userObject)).getOr(() -> null);
    }

    private Object getObject(JComponent c) {
        if (c instanceof JTree) {
            JTree sourceTree = (JTree)c;
            TreePath[] paths = sourceTree.getSelectionPaths();
            if (paths == null || paths.length != 1) {
                return null;
            }
            return this.getValue(paths[0].getLastPathComponent());
        }
        if (c instanceof JList) {
            JList list = (JList)c;
            return this.getValue(list.getSelectedValue());
        }
        return null;
    }

    private Object getValue(Object value) {
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            return node.getUserObject();
        }
        return value;
    }
}

