/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.tree;

import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class ReloadableFolderTreeNode<T>
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = Logging.getLogger((String)ReloadableFolderTreeNode.class.getName());
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNKNOWN);
    private final IFactory<T, List<DefaultMutableTreeNode>, RuntimeException> initializer;

    public ReloadableFolderTreeNode(IFactory<T, List<DefaultMutableTreeNode>, RuntimeException> initializer, T userObject) {
        super(userObject);
        this.initializer = initializer;
        this.children = new Vector();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        this.state.set(State.INITALIZED);
        super.add(newChild);
    }

    public boolean isInitialized() {
        return Objects.equals((Object)this.state.get(), (Object)State.INITALIZED);
    }

    public boolean isLoading() {
        return Objects.equals((Object)this.state.get(), (Object)State.LOADING);
    }

    public void load(DefaultTreeModel treeModel) {
        if (this.isInitialized() || this.isLoading()) {
            return;
        }
        this.loadTo(treeModel, () -> {});
    }

    public void reload(DefaultTreeModel treeModel, Runnable postProcess) {
        if (this.isLoading()) {
            return;
        }
        this.loadTo(treeModel, postProcess);
    }

    private void loadTo(final DefaultTreeModel treeModel, final Runnable postProcess) {
        this.state.set(State.LOADING);
        SwingWorker<List<DefaultMutableTreeNode>, Void> worker = new SwingWorker<List<DefaultMutableTreeNode>, Void>(){

            @Override
            protected List<DefaultMutableTreeNode> doInBackground() throws Exception {
                return (List)ReloadableFolderTreeNode.this.initializer.create(ReloadableFolderTreeNode.this.getUserObject());
            }

            @Override
            protected void done() {
                try {
                    List loadedNodes = (List)this.get();
                    if (loadedNodes == null) {
                        ReloadableFolderTreeNode.this.state.set(State.UNKNOWN);
                        super.done();
                        return;
                    }
                    ReloadableFolderTreeNode.this.state.set(State.INITALIZED);
                    GuiUtilities.invokeLater(() -> {
                        List<MutableTreeNode> nodes = ReloadableFolderTreeNode.this.children.stream().map(n -> (MutableTreeNode)n).toList();
                        for (MutableTreeNode defaultMutableTreeNode : nodes) {
                            treeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                        for (MutableTreeNode mutableTreeNode : loadedNodes) {
                            treeModel.insertNodeInto(mutableTreeNode, ReloadableFolderTreeNode.this, ReloadableFolderTreeNode.this.children.size());
                        }
                        postProcess.run();
                        treeModel.reload(ReloadableFolderTreeNode.this);
                    });
                    super.done();
                }
                catch (InterruptedException exception) {
                    logger.log(ILevel.ERROR, exception.getMessage(), (Throwable)exception);
                    ReloadableFolderTreeNode.this.state.set(State.UNKNOWN);
                    super.done();
                }
                catch (ExecutionException exception) {
                    logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                    ReloadableFolderTreeNode.this.state.set(State.FAILED);
                    super.done();
                }
            }
        };
        worker.execute();
    }

    public static enum State {
        UNKNOWN,
        LOADING,
        INITALIZED,
        FAILED;

    }
}

