/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import net.anwiba.commons.swing.tree.ITreeModel;
import net.anwiba.commons.swing.tree.ITreeNode;
import net.anwiba.commons.swing.tree.ReloadableFolderTreeNode;

public class TreeModel<T extends ITreeNode<?>>
implements ITreeModel<T> {
    private final T rootNode;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public TreeModel(T rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public int getChildCount(Object parent) {
        ReloadableFolderTreeNode reloadable;
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        if (parent instanceof ReloadableFolderTreeNode && !(reloadable = (ReloadableFolderTreeNode)parent).isInitialized()) {
            return 0;
        }
        return ((ITreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(node instanceof ITreeNode)) {
            throw new IllegalArgumentException("unsupported instance");
        }
        return ((ITreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        ReloadableFolderTreeNode reloadable;
        if (!(parent instanceof ITreeNode)) {
            throw new IllegalArgumentException("unsupported instance");
        }
        if (!(child instanceof ITreeNode)) {
            throw new IllegalArgumentException("unsupported instance");
        }
        if (parent instanceof ReloadableFolderTreeNode && !(reloadable = (ReloadableFolderTreeNode)parent).isInitialized()) {
            throw new IllegalStateException();
        }
        return ((ITreeNode)parent).getIndex((ITreeNode)child);
    }

    protected synchronized void fireTreeStructureChanged(T node) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(node));
        ArrayList<TreeModelListener> currentListeners = new ArrayList<TreeModelListener>(this.listeners);
        for (TreeModelListener listener : currentListeners) {
            listener.treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(source, path, childIndices, children);
        ArrayList<TreeModelListener> currentListeners = new ArrayList<TreeModelListener>(this.listeners);
        for (TreeModelListener listener : currentListeners) {
            listener.treeStructureChanged(treeModelEvent);
        }
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public T getRoot() {
        return this.rootNode;
    }

    @Override
    public T getChild(Object parent, int index) {
        ReloadableFolderTreeNode reloadable;
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        if (parent instanceof ReloadableFolderTreeNode && !(reloadable = (ReloadableFolderTreeNode)parent).isInitialized()) {
            throw new IllegalStateException();
        }
        return ((ITreeNode)parent).getChildAt(index);
    }
}

