/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.utilities.ContainerUtilities;

public class GuiUtilities
extends ContainerUtilities {
    private static ILogger logger = Logging.getLogger((String)GuiUtilities.class.getName());

    public static void center(Window window) {
        if (window == null) {
            return;
        }
        Window owner = window.getOwner();
        if (owner == null || owner.getBounds().equals(new Rectangle(0, 0, 0, 0))) {
            GuiUtilities.centerToScreen(window);
            return;
        }
        int x = owner.getX() + owner.getWidth() / 2 - window.getWidth() / 2;
        int y = owner.getY() + owner.getHeight() / 2 - window.getHeight() / 2;
        window.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    public static void centerToScreen(Window window) {
        if (window == null) {
            return;
        }
        DisplayMode displayMode = window.getGraphicsConfiguration().getDevice().getDisplayMode();
        Point location = GuiUtilities.getCenterToScreenLocation(displayMode, window.getSize());
        window.setLocation(location);
    }

    public static Point getCenterToScreenLocation(DisplayMode displayMode, Dimension size) {
        if (displayMode == null) {
            return new Point();
        }
        int x = displayMode.getWidth() / 2 - size.width / 2;
        int y = displayMode.getHeight() / 2 - size.height / 2;
        return new Point(x, y);
    }

    public static void invokeLater(Runnable runner) {
        if (EventQueue.isDispatchThread()) {
            runner.run();
            return;
        }
        EventQueue.invokeLater(runner);
    }

    public static void invokeAndWait(Runnable runner) {
        if (EventQueue.isDispatchThread()) {
            runner.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(runner);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            logger.log(ILevel.DEBUG, cause.getLocalizedMessage(), cause);
            throw new RuntimeException(cause);
        }
    }

    public static Component createGap(int width, boolean isElastic) {
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(width, 0));
        if (!isElastic) {
            panel.setMaximumSize(new Dimension(width, 1000));
        }
        return panel;
    }

    public static Set<Container> setContainerEnabled(Container control, boolean enabled) {
        return GuiUtilities.setContainerEnabled(control, enabled, new HashSet<Container>());
    }

    public static Set<Container> setContainerEnabled(Container container, boolean enable, Set<Container> components) {
        HashSet<Container> enabledComps = new HashSet<Container>();
        if (!components.contains(container)) {
            if (container.isEnabled() == enable) {
                enabledComps.add(container);
            } else if (container instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)container;
                Action action = b.getAction();
                if (action == null) {
                    b.setEnabled(enable);
                } else {
                    b.setEnabled(action.isEnabled() && enable);
                }
            } else {
                container.setEnabled(enable);
            }
        }
        return GuiUtilities.setSubComponentsEnabled(container, enable, components, enabledComps);
    }

    private static Set<Container> setSubComponentsEnabled(Container container, boolean enable, Set<Container> components, Set<Container> enabledComps) {
        Component[] containerComponents;
        for (Component component : containerComponents = container.getComponents()) {
            if (component instanceof Container) {
                Set<Container> enabledContainers = GuiUtilities.setContainerEnabled((Container)component, enable, components);
                enabledComps.addAll(enabledContainers);
                continue;
            }
            if (component.isEnabled() == enable) {
                enabledComps.add(container);
                continue;
            }
            component.setEnabled(enable);
        }
        return enabledComps;
    }

    public static JComponent decorate(LayoutManager layout, JComponent component) {
        return GuiUtilities.decorate(new JPanel(layout), component);
    }

    public static JComponent decorate(JComponent container, JComponent component) {
        container.add(component);
        return container;
    }

    public static JComponent decorate(LayoutManager layout, Object constaint, JComponent component) {
        return GuiUtilities.decorate(new JPanel(layout), constaint, component);
    }

    public static JComponent decorate(JComponent container, Object constaint, JComponent component) {
        container.add((Component)component, constaint);
        return container;
    }
}

