/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;

public class SpringLayoutUtilities {
    public static void makeGrid(Container parent, int cols, int rows, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout.Constraints cons;
        int i;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            throw new RuntimeException("The first argument to makeGrid must use SpringLayout.");
        }
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        for (i = 1; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
        }
        for (i = 0; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        for (int i2 = 0; i2 < max; ++i2) {
            SpringLayout.Constraints cons2 = layout.getConstraints(parent.getComponent(i2));
            if (i2 % cols == 0) {
                lastRowCons = lastCons;
                cons2.setX(initialXSpring);
            } else if (lastCons != null) {
                cons2.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            } else {
                throw new UnreachableCodeReachedException();
            }
            if (i2 / cols == 0) {
                cons2.setY(initialYSpring);
            } else if (lastRowCons != null) {
                cons2.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            } else {
                throw new UnreachableCodeReachedException();
            }
            lastCons = cons2;
        }
        if (lastCons == null) {
            throw new UnreachableCodeReachedException();
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(initialX), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(initialY), lastCons.getConstraint("East")));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int col, int row, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int cols, int rows, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            throw new RuntimeException("The first argument to makeCompactGrid must use SpringLayout.");
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, SpringLayoutUtilities.getConstraintsForCell(c, r, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = SpringLayoutUtilities.getConstraintsForCell(c, r, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        x = Spring.sum(x, Spring.sum(Spring.constant(-xPad), Spring.constant(initialX)));
        Spring y = Spring.constant(initialY);
        for (int row = 0; row < rows; ++row) {
            Spring height = Spring.constant(0);
            for (int c = 0; c < cols; ++c) {
                height = Spring.max(height, SpringLayoutUtilities.getConstraintsForCell(c, row, parent, cols).getHeight());
            }
            for (int col = 0; col < cols; ++col) {
                SpringLayout.Constraints constraints = SpringLayoutUtilities.getConstraintsForCell(col, row, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        y = Spring.sum(y, Spring.sum(Spring.constant(-yPad), Spring.constant(initialY)));
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

