/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import javax.swing.ImageIcon;
import net.anwiba.commons.swing.icon.GuiIconDecorator;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;

public class ConcatinatedGuiIcon
implements IGuiIcon {
    private final IGuiIcon icon;
    private final IGuiIcon[] additionalIcons;

    public ConcatinatedGuiIcon(IGuiIcon icon, IGuiIcon ... additionalIcons) {
        this.icon = icon;
        this.additionalIcons = additionalIcons;
    }

    @Override
    public ImageIcon getSmallIcon() {
        return this.concat(GuiIconSize.SMALL);
    }

    private ImageIcon concat(GuiIconSize size) {
        ImageIcon image = this.icon.getIcon(size);
        IGuiIcon[] iGuiIconArray = this.additionalIcons;
        int n = this.additionalIcons.length;
        int n2 = 0;
        while (n2 < n) {
            IGuiIcon additionalIcon = iGuiIconArray[n2];
            ImageIcon additionalImage = additionalIcon.getIcon(size);
            image = GuiIconDecorator.add(image, additionalImage, 0, 0, additionalImage.getIconWidth(), additionalImage.getIconHeight());
            ++n2;
        }
        return image;
    }

    @Override
    public ImageIcon getMediumIcon() {
        return this.concat(GuiIconSize.MEDIUM);
    }

    @Override
    public ImageIcon getLargeIcon() {
        return this.concat(GuiIconSize.LARGE);
    }

    @Override
    public ImageIcon getIcon(GuiIconSize size) {
        return this.concat(size);
    }

    @Override
    public boolean isDecorator() {
        return false;
    }
}

