/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import javax.swing.ImageIcon;
import net.anwiba.commons.swing.icon.DecorationPosition;
import net.anwiba.commons.swing.icon.GuiIcon;
import net.anwiba.commons.swing.icon.GuiIconDecorator;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;

public class DecoratedGuiIcon
implements IGuiIcon {
    private final IGuiIcon decoration;
    private final IGuiIcon icon;
    private final DecorationPosition position;

    public DecoratedGuiIcon(IGuiIcon icon, IGuiIcon decoration) {
        this.icon = icon;
        this.decoration = decoration;
        this.position = DecorationPosition.LowerLeft;
    }

    public DecoratedGuiIcon(GuiIcon icon, GuiIcon decoration, DecorationPosition position) {
        this.icon = icon;
        this.decoration = decoration;
        this.position = position;
    }

    @Override
    public ImageIcon getSmallIcon() {
        return GuiIconDecorator.decorate(GuiIconSize.SMALL, this.position, this.icon, this.decoration);
    }

    @Override
    public ImageIcon getMediumIcon() {
        return GuiIconDecorator.decorate(GuiIconSize.MEDIUM, this.position, this.icon, this.decoration);
    }

    @Override
    public ImageIcon getLargeIcon() {
        return GuiIconDecorator.decorate(GuiIconSize.LARGE, this.position, this.icon, this.decoration);
    }

    @Override
    public ImageIcon getIcon(GuiIconSize size) {
        return GuiIconDecorator.decorate(size, this.position, this.icon, this.decoration);
    }

    @Override
    public boolean isDecorator() {
        return false;
    }
}

