/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icon.IGuiIconSizeVisitor;

public final class StringDecorationIcon
implements IGuiIcon {
    private final Color backGroundColor;
    private final Color fontColor;
    private final String extention;

    public StringDecorationIcon(Color backGroundColor, Color fontColor, String extention) {
        this.backGroundColor = backGroundColor;
        this.fontColor = fontColor;
        this.extention = extention;
    }

    @Override
    public boolean isDecorator() {
        return true;
    }

    @Override
    public ImageIcon getSmallIcon() {
        return this.create(16, this.extention);
    }

    @Override
    public ImageIcon getMediumIcon() {
        return this.create(22, this.extention);
    }

    @Override
    public ImageIcon getLargeIcon() {
        return this.create(32, this.extention);
    }

    private ImageIcon create(int size, String string) {
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D graphic = (Graphics2D)image.getGraphics();
        Color color = graphic.getColor();
        Font font = graphic.getFont();
        try {
            graphic.setColor(this.backGroundColor);
            graphic.fillRect(0, size / 2, size, size / 2);
            graphic.setColor(this.fontColor);
            graphic.setFont(font.deriveFont((float)((double)size / 2.5)));
            graphic.drawString(string, 1, size - 2);
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        finally {
            graphic.setColor(color);
            graphic.setFont(font);
            graphic.dispose();
        }
    }

    @Override
    public ImageIcon getIcon(GuiIconSize size) {
        return size.accept(new IGuiIconSizeVisitor<ImageIcon>(){

            @Override
            public ImageIcon vistSmall() {
                return StringDecorationIcon.this.getSmallIcon();
            }

            @Override
            public ImageIcon vistMedium() {
                return StringDecorationIcon.this.getMediumIcon();
            }

            @Override
            public ImageIcon vistLarge() {
                return StringDecorationIcon.this.getLargeIcon();
            }
        });
    }
}

