/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.ImageIcon;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.resource.utilities.UriUtilities;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icon.IGuiIconSizeVisitor;
import net.anwiba.commons.swing.icon.IIconSize;
import net.anwiba.commons.swing.icon.IconSize;
import net.anwiba.commons.utilities.lang.ClassLoaderUtilities;

public class GuiIcon
implements IGuiIcon {
    private static ILogger logger = Logging.getLogger((String)GuiIcon.class.getName());
    private final IIconSize large;
    private final IIconSize medium;
    private final IIconSize small;
    private final boolean isDecorator;

    public GuiIcon(String small, String medium, String large) {
        this(IconSize.small(small), IconSize.medium(medium), IconSize.large(large), false);
    }

    public GuiIcon(IIconSize small, IIconSize medium, IIconSize large, boolean isDecorator) {
        this.small = small;
        this.medium = medium;
        this.large = large;
        this.isDecorator = isDecorator;
    }

    @Override
    public boolean isDecorator() {
        return this.isDecorator;
    }

    @Override
    public ImageIcon getSmallIcon() {
        return this.getIcon(this.small.getPath(), this.small.getSize());
    }

    @Override
    public ImageIcon getMediumIcon() {
        return this.getIcon(this.medium.getPath(), this.medium.getSize());
    }

    @Override
    public ImageIcon getLargeIcon() {
        return this.getIcon(this.large.getPath(), this.large.getSize());
    }

    private ImageIcon getIcon(String name, int size) {
        URL resource = this.getClass().getClassLoader().getResource(name);
        if (resource == null) {
            URI[] uris;
            Object object = uris = ClassLoaderUtilities.getClassPathUris((ClassLoader)this.getClass().getClassLoader());
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                URI uri = object[n2];
                if (UriUtilities.isFileUri((URI)uri) && (file = new File(new File(uri), name)).canRead()) {
                    try {
                        return new ImageIcon(file.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++n2;
            }
            logger.log(ILevel.FATAL, "Cannot find image resource: " + name);
            BufferedImage image = new BufferedImage(size, size, 2);
            Graphics2D graphic = (Graphics2D)image.getGraphics();
            try {
                graphic.setBackground(Color.RED);
                object = new ImageIcon(image);
                return object;
            }
            finally {
                graphic.dispose();
            }
        }
        return new ImageIcon(resource);
    }

    @Override
    public ImageIcon getIcon(GuiIconSize size) {
        IGuiIconSizeVisitor<ImageIcon> visitor = new IGuiIconSizeVisitor<ImageIcon>(){

            @Override
            public ImageIcon vistSmall() {
                return GuiIcon.this.getSmallIcon();
            }

            @Override
            public ImageIcon vistMedium() {
                return GuiIcon.this.getMediumIcon();
            }

            @Override
            public ImageIcon vistLarge() {
                return GuiIcon.this.getLargeIcon();
            }
        };
        return size.accept(visitor);
    }
}

