/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import net.anwiba.commons.swing.icon.DecoratedGuiIcon;
import net.anwiba.commons.swing.icon.DecorationPosition;
import net.anwiba.commons.swing.icon.GuiIcon;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icon.IGuiIconDecoration;
import net.anwiba.commons.swing.icon.IGuiIconSizeVisitor;

public class GuiIconDecorator {
    public static IGuiIcon icon(GuiIcon icon, GuiIcon decorationIcon, DecorationPosition position) {
        return new DecoratedGuiIcon(icon, decorationIcon, position);
    }

    public static ImageIcon decorate(GuiIconSize size, IGuiIcon icon, IGuiIconDecoration decoration) {
        return GuiIconDecorator.decorate(size, icon, decoration.getGuiIcon());
    }

    public static ImageIcon decorate(GuiIconSize size, IGuiIcon icon, IGuiIcon decorationIcon) {
        return GuiIconDecorator.decorate(size, DecorationPosition.LowerLeft, icon, decorationIcon);
    }

    public static ImageIcon decorate(final GuiIconSize size, final DecorationPosition position, final IGuiIcon icon, final IGuiIcon decorationIcon) {
        IGuiIconSizeVisitor<ImageIcon> visitor = new IGuiIconSizeVisitor<ImageIcon>(){

            @Override
            public ImageIcon vistSmall() {
                return GuiIconDecorator.decorate(size, position, icon.getSmallIcon(), decorationIcon);
            }

            @Override
            public ImageIcon vistMedium() {
                return GuiIconDecorator.decorate(size, position, icon.getMediumIcon(), decorationIcon);
            }

            @Override
            public ImageIcon vistLarge() {
                return GuiIconDecorator.decorate(size, position, icon.getLargeIcon(), decorationIcon);
            }
        };
        return size.accept(visitor);
    }

    public static ImageIcon decorate(GuiIconSize size, ImageIcon icon, IGuiIconDecoration decoration) {
        IGuiIcon decorationIcon = decoration.getGuiIcon();
        return GuiIconDecorator.decorate(size, icon, decorationIcon);
    }

    public static ImageIcon decorate(GuiIconSize size, ImageIcon icon, IGuiIcon decorationIcon) {
        return GuiIconDecorator.decorate(size, DecorationPosition.LowerLeft, icon, decorationIcon);
    }

    private static ImageIcon decorate(GuiIconSize size, final DecorationPosition position, final ImageIcon icon, final IGuiIcon decorationIcon) {
        IGuiIconSizeVisitor<ImageIcon> visitor = new IGuiIconSizeVisitor<ImageIcon>(){

            @Override
            public ImageIcon vistSmall() {
                if (decorationIcon.isDecorator()) {
                    return GuiIconDecorator.add(icon, decorationIcon.getSmallIcon());
                }
                return GuiIconDecorator.add(16, position, icon, decorationIcon.getSmallIcon());
            }

            @Override
            public ImageIcon vistMedium() {
                if (decorationIcon.isDecorator()) {
                    return GuiIconDecorator.add(icon, decorationIcon.getMediumIcon());
                }
                return GuiIconDecorator.add(22, position, icon, decorationIcon.getSmallIcon());
            }

            @Override
            public ImageIcon vistLarge() {
                if (decorationIcon.isDecorator()) {
                    return GuiIconDecorator.add(icon, decorationIcon.getLargeIcon());
                }
                return GuiIconDecorator.add(32, position, icon, decorationIcon.getSmallIcon());
            }
        };
        return size.accept(visitor);
    }

    protected static ImageIcon add(ImageIcon icon, ImageIcon decoration, int x, int y, int width, int height) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphic = (Graphics2D)image.getGraphics();
        try {
            graphic.drawImage(icon.getImage(), 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            });
            graphic.drawImage(decoration.getImage(), x, y, width, height, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            });
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        finally {
            graphic.dispose();
        }
    }

    public static ImageIcon add(ImageIcon icon, ImageIcon decoration) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphic = (Graphics2D)image.getGraphics();
        try {
            graphic.drawImage(icon.getImage(), 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            });
            graphic.drawImage(decoration.getImage(), 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            });
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        finally {
            graphic.dispose();
        }
    }

    private static ImageIcon add(int iconSize, DecorationPosition position, ImageIcon icon, ImageIcon decorationIcon) {
        Point point = GuiIconDecorator.getPosition(iconSize, position);
        return GuiIconDecorator.add(icon, decorationIcon, point.x, point.y, GuiIconDecorator.getSize(iconSize, position), GuiIconDecorator.getSize(iconSize, position));
    }

    public static int getSize(int iconSize, DecorationPosition position) {
        switch (position) {
            case UpperLeft: 
            case UpperRight: 
            case LowerLeft: 
            case LowerRight: {
                return iconSize * 2 / 3;
            }
            case Fill: {
                return iconSize;
            }
        }
        return iconSize * 2 / 3;
    }

    private static Point getPosition(int size, DecorationPosition position) {
        switch (position) {
            case LowerLeft: {
                return new Point(0, size - GuiIconDecorator.getSize(size, position));
            }
            case LowerRight: {
                return new Point(size - GuiIconDecorator.getSize(size, position), size - GuiIconDecorator.getSize(size, position));
            }
            case UpperLeft: {
                return new Point(0, 0);
            }
            case UpperRight: {
                return new Point(size - GuiIconDecorator.getSize(size, position), 0);
            }
            case Fill: {
                return new Point(0, 0);
            }
        }
        return new Point(0, 0);
    }
}

