/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.ImageIcon;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icon.IGuiIconSizeVisitor;
import net.anwiba.commons.swing.icon.IIconSize;
import net.anwiba.commons.swing.icon.IconSize;

public class GuiIcon
implements IGuiIcon {
    private static ILogger logger = Logging.getLogger((String)GuiIcon.class.getName());
    private final IIconSize large;
    private final IIconSize medium;
    private final IIconSize small;
    private final boolean isDecorator;
    private final Function<String, URL> urlResolver;

    public static GuiIcon of(String small, String medium, String large) {
        return new GuiIcon(new UrlResolver(), IconSize.small(small), IconSize.medium(medium), IconSize.large(large), false);
    }

    public static GuiIcon of(Function<String, URL> urlResolver, String small, String medium, String large) {
        return new GuiIcon(new UrlResolver(urlResolver), IconSize.small(small), IconSize.medium(medium), IconSize.large(large), false);
    }

    public static GuiIcon of(IIconSize small, IIconSize medium, IIconSize large, boolean isDecorator) {
        return new GuiIcon(new UrlResolver(), small, medium, large, isDecorator);
    }

    public static GuiIcon of(Class clazz, IIconSize small, IIconSize medium, IIconSize large) {
        return new GuiIcon(new UrlResolver(r -> clazz.getResource((String)r)), small, medium, large, false);
    }

    public static GuiIcon of(Class clazz, IIconSize small, IIconSize medium, IIconSize large, boolean isDecorator) {
        return new GuiIcon(new UrlResolver(r -> clazz.getResource((String)r)), small, medium, large, isDecorator);
    }

    public static GuiIcon of(Function<String, URL> urlResolver, IIconSize small, IIconSize medium, IIconSize large) {
        return new GuiIcon(new UrlResolver(urlResolver), small, medium, large, false);
    }

    public static GuiIcon of(Function<String, URL> urlResolver, IIconSize small, IIconSize medium, IIconSize large, boolean isDecorator) {
        return new GuiIcon(new UrlResolver(urlResolver), small, medium, large, isDecorator);
    }

    private GuiIcon(Function<String, URL> urlResolver, IIconSize small, IIconSize medium, IIconSize large, boolean isDecorator) {
        this.urlResolver = urlResolver;
        this.small = small;
        this.medium = medium;
        this.large = large;
        this.isDecorator = isDecorator;
    }

    @Override
    public boolean isDecorator() {
        return this.isDecorator;
    }

    @Override
    public ImageIcon getSmallIcon() {
        return this.getIcon(this.small.getPath(), this.small.getSize());
    }

    @Override
    public ImageIcon getMediumIcon() {
        return this.getIcon(this.medium.getPath(), this.medium.getSize());
    }

    @Override
    public ImageIcon getLargeIcon() {
        return this.getIcon(this.large.getPath(), this.large.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon getIcon(String name, int size) {
        URL resource = this.urlResolver.apply(name);
        if (resource != null) {
            return new ImageIcon(resource);
        }
        logger.log(ILevel.FATAL, "Cannot find image resource: " + name);
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D graphic = (Graphics2D)image.getGraphics();
        try {
            graphic.setBackground(Color.RED);
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        finally {
            graphic.dispose();
        }
    }

    @Override
    public ImageIcon getIcon(GuiIconSize size) {
        IGuiIconSizeVisitor<ImageIcon> visitor = new IGuiIconSizeVisitor<ImageIcon>(){

            @Override
            public ImageIcon vistSmall() {
                return GuiIcon.this.getSmallIcon();
            }

            @Override
            public ImageIcon vistMedium() {
                return GuiIcon.this.getMediumIcon();
            }

            @Override
            public ImageIcon vistLarge() {
                return GuiIcon.this.getLargeIcon();
            }
        };
        return size.accept(visitor);
    }

    private static class UrlResolver
    implements Function<String, URL> {
        private final Function<String, URL> urlResolver;

        public UrlResolver() {
            this(null);
        }

        public UrlResolver(Function<String, URL> urlResolver) {
            this.urlResolver = urlResolver == null ? path -> this.getClass().getResource((String)path) : urlResolver;
        }

        @Override
        public URL apply(String path) {
            if (path.startsWith("file:") || path.startsWith("http:") || path.startsWith("https:")) {
                try {
                    return new URL(path);
                }
                catch (MalformedURLException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    return null;
                }
            }
            Class<?> clazz = this.urlResolver.getClass();
            String resourceUrl = this.getResourceUrl(clazz, path);
            if (resourceUrl == null) {
                logger.log(ILevel.FATAL, "Missing image resource url");
                return null;
            }
            return Optional.of(resourceUrl).map(r -> this.urlResolver.apply((String)r)).orElseGet(() -> {
                logger.log(ILevel.FATAL, "Cannot find image resource: " + path + " class: " + clazz + " search path: " + resourceUrl);
                return null;
            });
        }

        private String getResourceUrl(Class<?> helper, String name) {
            Path packagePath;
            String[] pakkage = helper.getPackage().getName().split("\\.");
            Path iconsPath = Paths.get(name, new String[0]).normalize();
            if (iconsPath.startsWith(packagePath = Paths.get("", pakkage))) {
                return this.toString(packagePath.relativize(iconsPath));
            }
            return this.toString(iconsPath);
        }

        private String toString(Path path) {
            Object string = null;
            for (Path item : path) {
                if (string == null) {
                    string = item.toString();
                    continue;
                }
                string = (String)string + "/" + item.toString();
            }
            return string;
        }
    }
}

