/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon;

import net.anwiba.commons.swing.icon.IIconSize;

public class IconSize
implements IIconSize {
    private final int size;
    private final String path;

    public static IIconSize of(String parent, String path, int size) {
        Object relativePath;
        Object object = relativePath = path.startsWith("/") ? path : "/" + path;
        if (parent == null) {
            return IconSize.of((String)relativePath, size);
        }
        String parentPath = parent.startsWith("/") ? parent.substring(1, parent.length()) : parent;
        return IconSize.of(parentPath.endsWith("/") ? parentPath.substring(0, parentPath.length() - 1) + (String)relativePath : parentPath + (String)relativePath, size);
    }

    public static IIconSize of(String path, int size) {
        return new IconSize(path, size);
    }

    public static IIconSize small(String path) {
        return IconSize.of(path, 16);
    }

    public static IIconSize medium(String path) {
        return IconSize.of(path, 22);
    }

    public static IIconSize large(String path) {
        return IconSize.of(path, 32);
    }

    private IconSize(String path, int size) {
        this.path = path;
        this.size = size;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

