/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preferences;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.PreferenceUtilities;
import net.anwiba.commons.swing.dialog.ConfigurableDialogLauncher;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IContentPaneFactory;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.preferences.PreferencesPane;
import net.anwiba.commons.swing.preferences.editor.ParametersEditorFactoryRegistry;
import net.anwiba.commons.swing.preferences.tree.IPreferenceNode;

public final class PreferencesDialogAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final boolean isEditingEnabled;
    private final String title;
    private final IPreferences contentPreferences;
    private final IPreferences dialogPreferences;

    public PreferencesDialogAction(IPreferences dialogPreferences, String title, boolean isEditingEnabled, IPreferences contentPreferences) {
        super(title);
        this.isEditingEnabled = isEditingEnabled;
        this.title = title;
        this.contentPreferences = contentPreferences;
        this.dialogPreferences = dialogPreferences;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ParametersEditorFactoryRegistry editorFactoryRegistry = new ParametersEditorFactoryRegistry();
        IFunction<IPreferenceNode, Boolean, RuntimeException> storeFunction = new IFunction<IPreferenceNode, Boolean, RuntimeException>(){

            public Boolean execute(IPreferenceNode preferenceNode) throws RuntimeException {
                if (preferenceNode == null) {
                    return Boolean.TRUE;
                }
                String[] path = preferenceNode.getPath();
                Iterable parameters = preferenceNode.getParameters().parameters();
                PreferenceUtilities.store((String[])path, (Iterable)parameters);
                return Boolean.TRUE;
            }
        };
        PreferencesPane preferencesPane = new PreferencesPane(this.dialogPreferences, this.contentPreferences, this.isEditingEnabled, editorFactoryRegistry, storeFunction);
        this.show((Component)e.getSource(), this.dialogPreferences, preferencesPane, storeFunction);
    }

    public void show(Component component, IPreferences preferences, final PreferencesPane preferencesPane, IFunction<IPreferenceNode, Boolean, RuntimeException> storeFunction) {
        IContentPaneFactory contentPaneFactory = (owner, node) -> new AbstractContentPane(){

            public JComponent getComponent() {
                return preferencesPane.getComponent();
            }
        };
        new ConfigurableDialogLauncher().setPreferences(preferences).setTitle(this.title).setMessage(Message.create((String)this.title)).setContentPaneFactory(contentPaneFactory).setMessagePanelDisabled().addOnCloseExecutable(() -> {
            if (this.isEditingEnabled) {
                storeFunction.execute((Object)preferencesPane.getPreferenceNode());
            }
        }).setDialogType(DialogType.CLOSE).enableCloseOnEscape().launch(component);
    }
}

