/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.object.IObjectContainer;
import net.anwiba.commons.lang.object.ObjectContainer;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.component.IComponentProvider;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.StringFieldBuilder;
import net.anwiba.commons.swing.preference.SplitPanePreferenceUpdaterListener;
import net.anwiba.commons.swing.preferences.editor.IPreferenceNodeEditor;
import net.anwiba.commons.swing.preferences.editor.IPreferenceNodeEditorFactory;
import net.anwiba.commons.swing.preferences.editor.IPreferenceNodeEditorFactoryRegistry;
import net.anwiba.commons.swing.preferences.editor.PreferenceNodeEditorContext;
import net.anwiba.commons.swing.preferences.tree.IPreferenceNode;
import net.anwiba.commons.swing.preferences.tree.PreferenceNode;
import net.anwiba.commons.swing.preferences.tree.PreferenceNodeTreeFilter;
import net.anwiba.commons.swing.tree.FilteredTreeModel;
import net.anwiba.commons.swing.tree.ITreeNode;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.JTreeUtilities;

public class PreferencesPane
implements IComponentProvider {
    private JPanel contentPane;
    private final IPreferences panelPreferences;
    private final IPreferences contentPreferences;
    private final IPreferenceNodeEditorFactoryRegistry registry;
    final IObjectContainer<IPreferenceNodeEditor> editorContainer = new ObjectContainer();
    private final IFunction<IPreferenceNode, Boolean, RuntimeException> storeFunction;
    private final boolean isEditingEnabled;

    public PreferencesPane(IPreferences preferences, IPreferences contentPreferences, boolean isEditingEnabled, IPreferenceNodeEditorFactoryRegistry registry, IFunction<IPreferenceNode, Boolean, RuntimeException> storeFunction) {
        this.panelPreferences = preferences;
        this.contentPreferences = contentPreferences;
        this.isEditingEnabled = isEditingEnabled;
        this.registry = registry;
        this.storeFunction = storeFunction;
    }

    public JComponent getComponent() {
        if (this.contentPane == null) {
            this.contentPane = this.initialize();
        }
        return this.contentPane;
    }

    public JPanel initialize() {
        JPanel preferenceEditorContainer = new JPanel(new GridLayout(1, 1));
        preferenceEditorContainer.setPreferredSize(new Dimension(300, 200));
        final TreeModel treeModel = new TreeModel(new PreferenceNode(null, this.contentPreferences));
        final JTree tree = new JTree((javax.swing.tree.TreeModel)((Object)treeModel));
        IPreferenceNodeEditorFactoryRegistry registry = this.registry;
        tree.setRootVisible(true);
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        IObjectContainer<IPreferenceNodeEditor> preferenceNodeEditorContainer = this.editorContainer;
        IFunction<IPreferenceNode, Boolean, RuntimeException> storeFunction = this.storeFunction;
        boolean isEditingEnabled = this.isEditingEnabled;
        BooleanModel isNodeDeleteEnabledModel = new BooleanModel(false);
        selectionModel.addTreeSelectionListener(new TreeSelectionListener((IBooleanModel)isNodeDeleteEnabledModel, isEditingEnabled, registry, preferenceNodeEditorContainer, storeFunction, preferenceEditorContainer){
            private final /* synthetic */ IBooleanModel val$isNodeDeleteEnabledModel;
            private final /* synthetic */ boolean val$isEditingEnabled;
            private final /* synthetic */ IPreferenceNodeEditorFactoryRegistry val$registry;
            private final /* synthetic */ IObjectContainer val$preferenceNodeEditorContainer;
            private final /* synthetic */ IFunction val$storeFunction;
            private final /* synthetic */ JPanel val$preferenceEditorContainer;
            {
                this.val$isNodeDeleteEnabledModel = iBooleanModel;
                this.val$isEditingEnabled = bl;
                this.val$registry = iPreferenceNodeEditorFactoryRegistry;
                this.val$preferenceNodeEditorContainer = iObjectContainer;
                this.val$storeFunction = iFunction;
                this.val$preferenceEditorContainer = jPanel;
            }

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath newLeadSelectionPath = event.getNewLeadSelectionPath();
                PreferenceNode node = PreferencesPane.this.getPreferenceNode(newLeadSelectionPath);
                this.val$isNodeDeleteEnabledModel.set(this.val$isEditingEnabled && node != null && node.getParent() != null);
                PreferenceNodeEditorContext context = new PreferenceNodeEditorContext(this.val$isEditingEnabled, node);
                IPreferenceNodeEditorFactory editorFactory = this.val$registry.get(context);
                final IObjectContainer editorContainer = this.val$preferenceNodeEditorContainer;
                IPreferenceNodeEditor editor = (IPreferenceNodeEditor)editorContainer.get();
                editorContainer.set((Object)((IPreferenceNodeEditor)editorFactory.create(context)));
                GuiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        val$preferenceEditorContainer.removeAll();
                        IPreferenceNodeEditor preferenceNodeEditor = (IPreferenceNodeEditor)editorContainer.get();
                        if (preferenceNodeEditor == null) {
                            return;
                        }
                        val$preferenceEditorContainer.add(preferenceNodeEditor.getComponent());
                        val$preferenceEditorContainer.validate();
                        val$preferenceEditorContainer.repaint();
                    }
                });
                if (editor != null) {
                    this.val$storeFunction.execute((Object)editor.getPreferenceNode());
                }
            }
        });
        JScrollPane preferencesTreeScrollPane = new JScrollPane(tree);
        preferencesTreeScrollPane.setPreferredSize(new Dimension(150, 200));
        JSplitPane splitPane = new JSplitPane(1, preferencesTreeScrollPane, preferenceEditorContainer);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(1.0);
        SplitPanePreferenceUpdaterListener.connect((JSplitPane)splitPane, (IPreferences)this.panelPreferences);
        JPanel contentPane = new JPanel(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        final IObjectField stringField = ((StringFieldBuilder)new StringFieldBuilder().addClearAction("clear filter")).build();
        stringField.getModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                treeModel.getFilterReceiver().set((Object)new PreferenceNodeTreeFilter((String)stringField.getModel().get()));
                JTreeUtilities.expandAll((JTree)tree);
            }
        });
        toolbar.add(stringField.getComponent());
        toolbar.addSeparator();
        toolbar.add(new ConfigurableActionBuilder().setIcon((IGuiIcon)ContrastHightIcons.EDIT_DELETE).setEnabledDistributor((IBooleanDistributor)isNodeDeleteEnabledModel).setTooltip("Remove selected preference").setTask(() -> {
            PreferenceNode preferenceNode = this.getPreferenceNode(selectionModel.getLeadSelectionPath());
            Optional.of((Object)preferenceNode).convert(node -> node.getParent()).accept(node -> node != treeModel.getRoot()).consume(node -> selectionModel.setSelectionPath(this.getTreePath((PreferenceNode)treeModel.getRoot(), (PreferenceNode)node))).or(() -> selectionModel.setSelectionPath(new TreePath(new PreferenceNode[]{(PreferenceNode)treeModel.getRoot()})));
            treeModel.removeFromParent(preferenceNode);
        }).build());
        contentPane.add((Component)toolbar, "North");
        contentPane.add((Component)splitPane, "Center");
        return contentPane;
    }

    private TreePath getTreePath(PreferenceNode root, PreferenceNode node) {
        return new TreePath(this.getPathToRoot(root, node, 0));
    }

    public IPreferenceNode getPreferenceNode() {
        IPreferenceNodeEditor editor = (IPreferenceNodeEditor)this.editorContainer.get();
        if (editor == null) {
            return null;
        }
        return editor.getPreferenceNode();
    }

    private PreferenceNode getPreferenceNode(TreePath path) {
        if (path == null) {
            return null;
        }
        return (PreferenceNode)path.getLastPathComponent();
    }

    private PreferenceNode[] getPathToRoot(PreferenceNode root, PreferenceNode node, int depth) {
        PreferenceNode[] nodes;
        if (node == null) {
            return depth == 0 ? null : new PreferenceNode[depth];
        }
        int step = depth + 1;
        nodes = node == root ? (nodes = new PreferenceNode[step]) : this.getPathToRoot(root, node.getParent(), step);
        nodes[nodes.length - step] = node;
        return nodes;
    }

    public final class TreeModel
    extends FilteredTreeModel<PreferenceNode> {
        public TreeModel(PreferenceNode rootNode) {
            super((ITreeNode)rootNode);
        }

        public void removeFromParent(PreferenceNode node) {
            PreferenceNode parent = node.getParent();
            int[] childIndex = new int[1];
            Object[] removedArray = new Object[1];
            childIndex[0] = parent.getIndex(node);
            parent.remove(node);
            removedArray[0] = node;
            this.fireTreeNodesRemoved(parent, PreferencesPane.this.getPathToRoot((PreferenceNode)this.getRoot(), parent, 0), childIndex, removedArray);
        }
    }
}

