/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preferences.editor;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.anwiba.commons.swing.parameter.ParameterTable;
import net.anwiba.commons.swing.parameter.ParameterTableModel;
import net.anwiba.commons.swing.preferences.editor.IPreferenceNodeEditor;
import net.anwiba.commons.swing.preferences.tree.IPreferenceNode;
import net.anwiba.commons.swing.preferences.tree.PreferenceNode;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.ParametersBuilder;

public class DefaultPreferenceNodeEditor
implements IPreferenceNodeEditor {
    private final PreferenceNode node;
    final ParameterTableModel parameterTableModel = new ParameterTableModel(true);
    private final boolean isEditable;

    public DefaultPreferenceNodeEditor(boolean isEditable, PreferenceNode node) {
        this.isEditable = isEditable;
        this.node = node;
        this.parameterTableModel.setParameters(node == null ? new ParametersBuilder().build() : node.getParameters());
    }

    public JComponent getComponent() {
        if (this.node == null || this.parameterTableModel.getRowCount() == 0) {
            return new JPanel();
        }
        ParameterTable table = new ParameterTable(this.parameterTableModel);
        if (!this.isEditable) {
            table.setCellEditor(null);
        }
        JScrollPane parameterScrollPane = new JScrollPane((Component)table);
        parameterScrollPane.setPreferredSize(new Dimension(300, 200));
        return parameterScrollPane;
    }

    @Override
    public IPreferenceNode getPreferenceNode() {
        if (this.node == null) {
            return null;
        }
        final String[] path = this.node.getPath();
        final IParameters parameters = this.parameterTableModel.getParameters();
        return new IPreferenceNode(){

            @Override
            public String[] getPath() {
                return path;
            }

            @Override
            public IParameters getParameters() {
                return parameters;
            }
        };
    }
}

