/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preferences.tree;

import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.PreferenceUtilities;
import net.anwiba.commons.swing.preferences.tree.IPreferenceNode;
import net.anwiba.commons.swing.tree.ITreeNode;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class PreferenceNode
implements ITreeNode<PreferenceNode>,
IPreferenceNode {
    private final IPreferences preferences;
    private final PreferenceNode parent;

    public PreferenceNode(PreferenceNode parent, IPreferences preferences) {
        this.parent = parent;
        this.preferences = preferences;
    }

    public PreferenceNode getChildAt(int childIndex) {
        return new PreferenceNode(this, (IPreferences)this.preferences.nodes().get(childIndex));
    }

    public int getChildCount() {
        return this.preferences.nodes().size();
    }

    public PreferenceNode getParent() {
        return this.parent;
    }

    public int getIndex(PreferenceNode node) {
        return this.preferences.nodes().indexOf(node.preferences);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public Iterable<PreferenceNode> children() {
        final PreferenceNode parent = this;
        return IterableUtilities.convert((Iterable)this.preferences.nodes(), (IConverter)new IConverter<IPreferences, PreferenceNode, RuntimeException>(){

            public PreferenceNode convert(IPreferences preferences) {
                return new PreferenceNode(parent, preferences);
            }
        });
    }

    public void remove(PreferenceNode node) {
        this.preferences.node(new String[]{node.getName()}).delete();
    }

    public String getName() {
        return this.preferences.getName();
    }

    public String toString() {
        return this.preferences.getName();
    }

    @Override
    public IParameters getParameters() {
        return PreferenceUtilities.getParameters((IPreferences)this.preferences);
    }

    @Override
    public String[] getPath() {
        return this.preferences.getPath();
    }
}

