/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preferences.tree;

import java.util.List;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.swing.preferences.tree.PreferenceNode;
import net.anwiba.commons.swing.tree.ITreeNodeFilter;
import net.anwiba.commons.utilities.collection.ListUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class PreferenceNodeTreeFilter
implements ITreeNodeFilter<PreferenceNode> {
    IAcceptor<PreferenceNode> acceptor;

    public PreferenceNodeTreeFilter(final String string) {
        this.acceptor = new IAcceptor<PreferenceNode>(){

            public boolean accept(PreferenceNode value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)string)) {
                    return true;
                }
                return this.evaluate(value);
            }

            private boolean evaluate(PreferenceNode node) {
                return this.contains(node.toString(), string) || this.evaluate(node.getParameters()) || this.evaluate(node.children());
            }

            private boolean evaluate(IParameters parameters) {
                for (IParameter parameter : parameters.parameters()) {
                    if (!this.contains(parameter.getName(), string) && !this.contains(parameter.getValue(), string)) continue;
                    return true;
                }
                return false;
            }

            private boolean contains(String string2, String value) {
                return value == null ? false : string2.toString().toUpperCase().contains(value.toUpperCase());
            }

            private boolean evaluate(Iterable<PreferenceNode> children) {
                for (PreferenceNode child : children) {
                    if (!this.evaluate(child)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public PreferenceNode getChild(PreferenceNode parent, int index) {
        List list = ListUtilities.filter(parent.children(), this.acceptor);
        return (PreferenceNode)list.get(index);
    }

    public int getIndexOfChild(PreferenceNode parent, PreferenceNode child) {
        List list = ListUtilities.filter(parent.children(), this.acceptor);
        return list.indexOf(child);
    }

    public int getChildCount(PreferenceNode parent) {
        List list = ListUtilities.filter(parent.children(), this.acceptor);
        return list.size();
    }
}

