/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.IProcessModelListener;
import net.anwiba.commons.swing.process.ProcessContextModel;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;
import net.anwiba.commons.thread.cancel.CancelerProcess;
import net.anwiba.commons.thread.process.IProcess;
import net.anwiba.commons.thread.process.IProcessManager;

public class ProcessItemPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public ProcessItemPanel(IProcessManager manager, ProcessContextModel model) {
        JLabel label = new JLabel(model.getDescription());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout(0, 2, 2));
        labelPanel.add(label);
        CancelAction action = new CancelAction(manager, model);
        JButton button = new JButton(action);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setEnabled(model.isEnabled());
        JProgressBar progressBar = new JProgressBar();
        final JPanel progessPanel = new JPanel();
        final JLabel noteLable = new JLabel();
        progessPanel.setLayout(new FlowLayout(0, 2, 2));
        progessPanel.add(button);
        progessPanel.add(progressBar);
        progessPanel.add(noteLable);
        this.setLayout(new SpringLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add(labelPanel);
        this.add(progessPanel);
        SpringLayoutUtilities.makeCompactGrid((Container)this, (int)1, (int)2, (int)2, (int)2, (int)2, (int)2);
        progressBar.setIndeterminate(true);
        model.addProcessModelListener(new IProcessModelListener(){

            @Override
            public void noteChanged(final String note) {
                GuiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        noteLable.setText(note);
                        progessPanel.revalidate();
                        ProcessItemPanel.this.revalidate();
                    }
                });
            }

            @Override
            public void messageAdded(IProcessMessageContext message) {
            }
        });
    }

    public static final class CancelAction
    extends AbstractAction {
        private final ProcessContextModel model;
        private static final long serialVersionUID = 1L;
        private final IProcessManager manager;

        public CancelAction(IProcessManager manager, ProcessContextModel model) {
            super(null, model.isEnabled() ? GuiIcons.CANCEL_ICON.getSmallIcon() : GuiIcons.DISABLED_CANCEL_ICON.getSmallIcon());
            this.manager = manager;
            this.model = model;
            this.setEnabled(model.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.model.isEnabled()) {
                return;
            }
            this.manager.execute((IProcess)new CancelerProcess(this.model.getCanceler(), "Cancel " + this.model.getDescription()));
        }
    }
}

