/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.BorderLayout;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.process.ProcessContextModel;
import net.anwiba.commons.swing.process.ProcessContextModelListModel;
import net.anwiba.commons.swing.process.ProcessItemPanel;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.process.IProcessManager;

public class ProcessListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JPanel listPanel = new JPanel();
    private final ProcessContextModelListModel model;
    private final IProcessManager manager;

    public ProcessListPanel(IProcessManager manager, ProcessContextModelListModel model) {
        this.manager = manager;
        Ensure.ensureArgumentNotNull((Object)((Object)model));
        this.setLayout(new BorderLayout());
        this.add("North", this.listPanel);
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 3));
        this.model = model;
        model.addListModelListener((IChangeableListListener)new IChangeableListListener<ProcessContextModel>(){

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<ProcessContextModel> models) {
                ProcessListPanel.this.updateView();
            }

            public void objectsAdded(Iterable<Integer> indeces, Iterable<ProcessContextModel> models) {
                ProcessListPanel.this.updateView();
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<ProcessContextModel> oldObjects, Iterable<ProcessContextModel> newObjects) {
                ProcessListPanel.this.updateView();
            }

            public void objectsChanged(Iterable<ProcessContextModel> oldObjects, Iterable<ProcessContextModel> newObjects) {
                ProcessListPanel.this.updateView();
            }
        });
        this.updateView();
    }

    protected void updateView() {
        this.listPanel.removeAll();
        ProcessContextModel[] processContextModelArray = this.model.getProcessModels();
        int n = processContextModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessContextModel process = processContextModelArray[n2];
            this.listPanel.add(new ProcessItemPanel(this.manager, process));
            ++n2;
        }
        GuiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ProcessListPanel.this.isVisible()) {
                    return;
                }
                ProcessListPanel.this.revalidate();
                ProcessListPanel.this.repaint();
            }
        });
    }
}

