/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.ProcessMessageContextDialog;
import net.anwiba.commons.swing.process.ProcessMessageContextTableCellRenderer;
import net.anwiba.commons.swing.process.ProcessMessageContextTableModel;
import net.anwiba.commons.swing.process.ProcessMessages;
import net.anwiba.commons.swing.process.action.ProcessMessagePropertiesAction;
import net.anwiba.commons.swing.process.action.ProcessMessageRemoveAction;
import net.anwiba.commons.swing.process.action.ProcessMessageRemoveAllAction;
import net.anwiba.commons.swing.table.ColumnConfiguration;
import net.anwiba.commons.swing.table.IColumnConfiguration;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ObjectTable;
import net.anwiba.commons.swing.table.ObjectTableConfigurationBuilder;
import net.anwiba.commons.swing.utilities.ContainerUtilities;

public class ProcessMessageTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public ProcessMessageTablePanel(Window owner, ProcessMessageContextTableModel processMessageContextTableModel) {
        ProcessMessageContextTableCellRenderer cellRenderer = new ProcessMessageContextTableCellRenderer();
        IObjectTableConfiguration<IProcessMessageContext> configuration = this.createTableConfiguration(cellRenderer);
        ObjectTable objectTable = new ObjectTable(configuration, (IObjectTableModel)processMessageContextTableModel);
        JComponent tableComponent = objectTable.getComponent();
        tableComponent.setPreferredSize(new Dimension(200, 100));
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ISelectionModel selectionModel = objectTable.getSelectionModel();
        ProcessMessageRemoveAction removeAction = new ProcessMessageRemoveAction(processMessageContextTableModel, (ISelectionModel<IProcessMessageContext>)selectionModel);
        ProcessMessageRemoveAllAction removeAllAction = new ProcessMessageRemoveAllAction(processMessageContextTableModel);
        ProcessMessagePropertiesAction propertiesAction = new ProcessMessagePropertiesAction(owner, (ISelectionModel<IProcessMessageContext>)selectionModel);
        removeAction.setEnabled(false);
        removeAllAction.setEnabled(processMessageContextTableModel.getRowCount() > 0);
        propertiesAction.setEnabled(false);
        toolBar.add(removeAction);
        toolBar.add(removeAllAction);
        toolBar.add(propertiesAction);
        this.add("North", toolBar);
        this.add("Center", tableComponent);
        selectionModel.addSelectionListener((ISelectionListener)new SelectionListener((ISelectionModel<IProcessMessageContext>)selectionModel, propertiesAction, removeAction));
        processMessageContextTableModel.addTableModelListener(new ActionHandlingTableModelListener(processMessageContextTableModel, removeAllAction));
    }

    private IObjectTableConfiguration<IProcessMessageContext> createTableConfiguration(TableCellRenderer cellRenderer) {
        ObjectTableConfigurationBuilder configurationBuilder = new ObjectTableConfigurationBuilder();
        configurationBuilder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)ProcessMessages.TYPE, cellRenderer, 20, true, null));
        configurationBuilder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)"Date", cellRenderer, 100, true, null));
        configurationBuilder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)ProcessMessages.PROCESS, cellRenderer, 100, true, null));
        configurationBuilder.addColumnConfiguration((IColumnConfiguration)new ColumnConfiguration((Object)ProcessMessages.MESSAGE, cellRenderer, 150, true, null));
        configurationBuilder.setMouseListenerFactory((IMouseListenerFactory)new IMouseListenerFactory<IProcessMessageContext>(){

            public MouseListener create(IObjectTableModel<IProcessMessageContext> tableModel, ISelectionIndexModel<IProcessMessageContext> selectionIndexModel, final ISelectionModel<IProcessMessageContext> selectionModel, IBooleanDistributor sortStateModel) {
                return new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        if (event.getClickCount() == 2 && !selectionModel.isEmpty()) {
                            ProcessMessageContextDialog dialog = new ProcessMessageContextDialog(ContainerUtilities.getParentWindow((Component)event.getComponent()), (IProcessMessageContext)selectionModel.getSelectedObjects().iterator().next());
                            dialog.setVisible(true);
                        }
                    }
                };
            }
        });
        return configurationBuilder.build();
    }

    public static final class ActionHandlingTableModelListener
    implements TableModelListener {
        private final ProcessMessageContextTableModel processMessageContextTableModel;
        private final ProcessMessageRemoveAllAction removeAllAction;

        public ActionHandlingTableModelListener(ProcessMessageContextTableModel processMessageContextTableModel, ProcessMessageRemoveAllAction removeAllAction) {
            this.processMessageContextTableModel = processMessageContextTableModel;
            this.removeAllAction = removeAllAction;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.removeAllAction.setEnabled(this.processMessageContextTableModel.getRowCount() > 0);
        }
    }

    public static final class SelectionListener
    implements ISelectionListener<IProcessMessageContext> {
        private final ISelectionModel<IProcessMessageContext> selectionModel;
        private final ProcessMessagePropertiesAction propertiesAction;
        private final ProcessMessageRemoveAction removeAction;

        public SelectionListener(ISelectionModel<IProcessMessageContext> selectionModel, ProcessMessagePropertiesAction propertiesAction, ProcessMessageRemoveAction removeAction) {
            this.selectionModel = selectionModel;
            this.propertiesAction = propertiesAction;
            this.removeAction = removeAction;
        }

        public void selectionChanged(SelectionEvent<IProcessMessageContext> event) {
            this.removeAction.setEnabled(!this.selectionModel.isEmpty());
            this.propertiesAction.setEnabled(this.selectionModel.size() == 1);
        }
    }
}

