/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.observer.IMessageAddedListener;
import net.anwiba.commons.message.observer.IObservableMessageCollector;
import net.anwiba.commons.swing.process.IBasicProgessBar;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.ProcessContextModel;
import net.anwiba.commons.swing.process.ProcessContextModelListModel;
import net.anwiba.commons.swing.process.action.OpenProcessManagerDialogAction;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.process.IProcessContext;
import net.anwiba.commons.thread.process.IProcessIdentfier;
import net.anwiba.commons.thread.process.IProcessListener;
import net.anwiba.commons.thread.process.IProcessManager;

public class ProcessStateBarPanel
extends JPanel
implements IBasicProgessBar {
    final transient ProcessContextModelListModel processContextModelListModel = new ProcessContextModelListModel();
    final JProgressBar progressBar = new JProgressBar();

    public ProcessStateBarPanel(Window owner, IProcessManager processManager, IObservableMessageCollector messageCollector) {
        messageCollector.addMessageAddedListener(new IMessageAddedListener(){

            public void messageAdded(final IMessage message) {
                final LocalDateTime time = LocalDateTime.now();
                ProcessStateBarPanel.this.processContextModelListModel.addMessage(new IProcessMessageContext(){
                    IProcessIdentfier processIdentfier = new IProcessIdentfier(){

                        public String toString() {
                            return "";
                        }
                    };

                    @Override
                    public IProcessIdentfier getProcessIdentfier() {
                        return this.processIdentfier;
                    }

                    @Override
                    public LocalDateTime getTime() {
                        return time;
                    }

                    @Override
                    public String getProcessDescription() {
                        return "";
                    }

                    @Override
                    public IMessage getMessage() {
                        return message;
                    }
                });
            }
        });
        processManager.addProcessListener((IProcessListener)new ProcessListener(this.processContextModelListModel, this));
        this.setLayout(new FlowLayout(0, 0, 0));
        OpenProcessManagerDialogAction action = new OpenProcessManagerDialogAction(owner, processManager, this.processContextModelListModel);
        JButton button = new JButton(action);
        button.setMaximumSize(button.getMinimumSize());
        button.setBackground(this.getBackground());
        button.setBorder(BorderFactory.createEtchedBorder(1));
        this.add(button);
        this.progressBar.setPreferredSize(new Dimension(50, button.getMinimumSize().height - 1));
        this.progressBar.setVisible(this.progressBar.isIndeterminate());
        this.add(this.progressBar);
    }

    @Override
    public final synchronized void setIndeterminate(final boolean value) {
        final JProgressBar progressBar = this.progressBar;
        GuiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (progressBar.isIndeterminate() != value) {
                    progressBar.setIndeterminate(value);
                }
                if (progressBar.isVisible() != value) {
                    progressBar.setVisible(value);
                    progressBar.revalidate();
                }
            }
        });
    }

    private static final class ProcessListener
    implements IProcessListener {
        private final Map<IProcessIdentfier, ProcessContextModel> processes = new HashMap<IProcessIdentfier, ProcessContextModel>();
        private final ProcessContextModelListModel processContextModelListModel;
        private final IBasicProgessBar progressBar;

        public ProcessListener(ProcessContextModelListModel processContextModelListModel, IBasicProgessBar progressBar) {
            this.processContextModelListModel = processContextModelListModel;
            this.progressBar = progressBar;
        }

        public synchronized void processStarted(IProcessContext context) {
            this.progressBar.setIndeterminate(true);
            ProcessContextModel model = new ProcessContextModel(context);
            this.processes.put(context.getProcessIdentfier(), model);
            this.processContextModelListModel.addProcessContextModel(model);
        }

        public synchronized void processFinished(IProcessIdentfier processIdentfier) {
            this.processContextModelListModel.removeProcessContextModel(this.processes.remove(processIdentfier));
        }

        public synchronized void allProgressesFinished() {
            this.progressBar.setIndeterminate(false);
        }
    }
}

