/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.IProcessModelListener;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.process.IProcessContext;
import net.anwiba.commons.thread.process.IProcessIdentfier;
import net.anwiba.commons.thread.process.IProcessMonitorListener;

public class ProcessContextModel {
    private String note;
    private final IProcessContext context;
    private final Object mutex = new Object();
    private final List<IProcessModelListener> processModelListeners = new ArrayList<IProcessModelListener>();

    public ProcessContextModel(IProcessContext context) {
        Ensure.ensureArgumentNotNull((Object)context);
        this.context = context;
        context.getMonitor().addProcessMonitorListener(new IProcessMonitorListener(){

            public void processNoteChanged(IProcessIdentfier processIdentfier, String processDescription, String note) {
                ProcessContextModel.this.setNote(note);
            }

            public void processMessageAdded(final IProcessIdentfier processIdentfier, final String processDescription, final IMessage message) {
                final LocalDateTime time = LocalDateTime.now();
                IProcessMessageContext messageContext = new IProcessMessageContext(){

                    @Override
                    public IProcessIdentfier getProcessIdentfier() {
                        return processIdentfier;
                    }

                    @Override
                    public String getProcessDescription() {
                        return processDescription;
                    }

                    @Override
                    public IMessage getMessage() {
                        return message;
                    }

                    @Override
                    public LocalDateTime getTime() {
                        return time;
                    }
                };
                ProcessContextModel.this.addMessage(messageContext);
            }
        });
    }

    public String getDescription() {
        return this.context.getProcessDescription();
    }

    public boolean isEnabled() {
        return this.context.getCanceler().isEnabled();
    }

    public ICanceler getCanceler() {
        return this.context.getCanceler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String note) {
        Object object = this.mutex;
        synchronized (object) {
            if (ObjectUtilities.equals((Object)note, (Object)this.note)) {
                return;
            }
            this.note = note;
        }
        this.fireNoteChanged(note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNote() {
        Object object = this.mutex;
        synchronized (object) {
            return this.note;
        }
    }

    public void addMessage(IProcessMessageContext messageContext) {
        this.fireMessageAdded(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageAdded(IProcessMessageContext messageContext) {
        ArrayList<IProcessModelListener> listeners = new ArrayList<IProcessModelListener>();
        List<IProcessModelListener> list = this.processModelListeners;
        synchronized (list) {
            listeners.addAll(this.processModelListeners);
        }
        for (IProcessModelListener listener : listeners) {
            listener.messageAdded(messageContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProcessModelListener(IProcessModelListener listener) {
        List<IProcessModelListener> list = this.processModelListeners;
        synchronized (list) {
            this.processModelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProcessModelListener(IProcessModelListener listener) {
        List<IProcessModelListener> list = this.processModelListeners;
        synchronized (list) {
            this.processModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireNoteChanged(String value) {
        ArrayList<IProcessModelListener> listeners = new ArrayList<IProcessModelListener>();
        List<IProcessModelListener> list = this.processModelListeners;
        synchronized (list) {
            listeners.addAll(this.processModelListeners);
        }
        for (IProcessModelListener listener : listeners) {
            listener.noteChanged(value);
        }
    }
}

