/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.Window;
import javax.swing.Icon;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.tabbed.IDialogTab;
import net.anwiba.commons.swing.dialog.tabbed.TabbedDialog;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.IProcessMessageListener;
import net.anwiba.commons.swing.process.ProcessContextModelListModel;
import net.anwiba.commons.swing.process.ProcessListTab;
import net.anwiba.commons.swing.process.ProcessMessageContextTableModel;
import net.anwiba.commons.swing.process.ProcessMessageTableTab;
import net.anwiba.commons.swing.process.ProcessMessages;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.process.IProcessManager;

public class ProcessManagerDialog
extends TabbedDialog {
    static ILogger logger = Logging.getLogger((String)ProcessManagerDialog.class.getName());
    private final ProcessMessageContextTableModel tableModel = new ProcessMessageContextTableModel();
    private final IProcessMessageListener processMessageListener = new ProcessMessageListener(this.tableModel);
    private final ProcessContextModelListModel processContextModelListModel;

    public ProcessManagerDialog(Window owner, IProcessManager manager, ProcessContextModelListModel processContextModelListModel) {
        super(owner, ProcessMessages.PROCESS_MANAGER, Message.create((String)ProcessMessages.PROCESS_MANAGER, (String)""), (Icon)GuiIcons.TASKBAR_ICON.getLargeIcon(), DialogType.NONE, false);
        this.processContextModelListModel = processContextModelListModel;
        this.tableModel.add(processContextModelListModel.getProcessContextMessages());
        this.tableModel.addListModelListener(new ProcessMessageContextTableModelListener());
        this.addTab((IDialogTab)new ProcessListTab(manager, processContextModelListModel));
        this.addTab((IDialogTab)new ProcessMessageTableTab((Window)((Object)this), this.tableModel));
        processContextModelListModel.addProcessMessageListener(this.processMessageListener);
        this.pack();
        GuiUtilities.center((Window)((Object)this));
    }

    public void dispose() {
        super.dispose();
        this.processContextModelListModel.removeProcessMessageListener(this.processMessageListener);
    }

    void removeMessages(Iterable<IProcessMessageContext> contexts) {
        for (IProcessMessageContext context : contexts) {
            this.processContextModelListModel.removeMessage(context);
        }
    }

    public static final class AddMessageContextRunner
    implements Runnable {
        private final IProcessMessageContext messageContext;
        private final ProcessMessageContextTableModel tableModel;

        public AddMessageContextRunner(ProcessMessageContextTableModel tableModel, IProcessMessageContext messageContext) {
            this.tableModel = tableModel;
            this.messageContext = messageContext;
        }

        @Override
        public void run() {
            try {
                this.tableModel.add(new IProcessMessageContext[]{this.messageContext});
            }
            catch (Exception exception) {
                logger.log(ILevel.WARNING, "add message faild", (Throwable)exception);
            }
        }
    }

    final class ProcessMessageContextTableModelListener
    implements IChangeableListListener<IProcessMessageContext> {
        ProcessMessageContextTableModelListener() {
        }

        public void objectsAdded(Iterable<Integer> indeces, Iterable<IProcessMessageContext> object) {
        }

        public void objectsRemoved(Iterable<Integer> indeces, Iterable<IProcessMessageContext> objects) {
            ProcessManagerDialog.this.removeMessages(objects);
        }

        public void objectsUpdated(Iterable<Integer> indeces, Iterable<IProcessMessageContext> oldObjects, Iterable<IProcessMessageContext> newObjects) {
        }

        public void objectsChanged(Iterable<IProcessMessageContext> oldObjects, Iterable<IProcessMessageContext> newObjects) {
        }
    }

    public static final class ProcessMessageListener
    implements IProcessMessageListener {
        private final ProcessMessageContextTableModel tableModel;

        public ProcessMessageListener(ProcessMessageContextTableModel tableModel) {
            this.tableModel = tableModel;
        }

        @Override
        public void messageAdded(IProcessMessageContext messageContext) {
            GuiUtilities.invokeLater((Runnable)new AddMessageContextRunner(this.tableModel, messageContext));
        }

        @Override
        public void messageRemoved(IProcessMessageContext messageContext) {
            GuiUtilities.invokeLater((Runnable)new RemoveMessageContextRunner(this.tableModel, messageContext));
        }
    }

    public static final class RemoveMessageContextRunner
    implements Runnable {
        private final IProcessMessageContext messageContext;
        private final ProcessMessageContextTableModel tableModel;

        public RemoveMessageContextRunner(ProcessMessageContextTableModel tableModel, IProcessMessageContext messageContext) {
            this.tableModel = tableModel;
            this.messageContext = messageContext;
        }

        @Override
        public void run() {
            try {
                this.tableModel.remove(new IProcessMessageContext[]{this.messageContext});
            }
            catch (Exception exception) {
                logger.log(ILevel.WARNING, "remove message faild", (Throwable)exception);
            }
        }
    }
}

