/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.ProcessMessageContextTableModel;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public final class ProcessMessageRemoveAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final ProcessMessageContextTableModel tableModel;
    private final ISelectionModel<IProcessMessageContext> selectionModel;

    public ProcessMessageRemoveAction(ProcessMessageContextTableModel tableModel, ISelectionModel<IProcessMessageContext> selectionModel) {
        super(DialogMessages.REMOVE, GuiIcons.DELETE_ICON.getSmallIcon());
        this.tableModel = tableModel;
        this.selectionModel = selectionModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IProcessMessageContext[] contexts = (IProcessMessageContext[])IterableUtilities.toArray((Iterable)this.selectionModel.getSelectedObjects(), IProcessMessageContext.class);
        ProcessMessageContextTableModel contextTableModel = this.tableModel;
        GuiUtilities.invokeLater((Runnable)new RemoveRunner(contextTableModel, contexts));
    }

    public static final class RemoveRunner
    implements Runnable {
        private final ProcessMessageContextTableModel contextTableModel;
        private final IProcessMessageContext[] contexts;

        public RemoveRunner(ProcessMessageContextTableModel contextTableModel, IProcessMessageContext[] contexts) {
            this.contextTableModel = contextTableModel;
            this.contexts = contexts;
        }

        @Override
        public void run() {
            this.contextTableModel.remove(this.contexts);
        }
    }
}

