/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anwiba.commons.model.AbstractListChangedNotifier;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.IProcessMessageListener;
import net.anwiba.commons.swing.process.IProcessModelListener;
import net.anwiba.commons.swing.process.ProcessContextModel;

public class ProcessContextModelListModel
extends AbstractListChangedNotifier<ProcessContextModel> {
    List<ProcessContextModel> processes = new ArrayList<ProcessContextModel>();
    List<IProcessMessageContext> messages = new ArrayList<IProcessMessageContext>();
    private final List<IProcessMessageListener> processMessageListeners = new ArrayList<IProcessMessageListener>();
    private final IProcessModelListener processListener = new IProcessModelListener(){

        @Override
        public void noteChanged(String value) {
        }

        @Override
        public void messageAdded(IProcessMessageContext message) {
            ProcessContextModelListModel.this.addMessage(message);
        }
    };
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(IProcessMessageContext message) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.messages.contains(message)) {
                return;
            }
            this.messages.add(message);
        }
        this.fireMessageAdded(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(IProcessMessageContext message) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.messages.remove(message)) {
                return;
            }
        }
        this.fireMessageRemoved(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProcessContextModel(ProcessContextModel process) {
        Object object = this.mutex;
        synchronized (object) {
            if (process == null || this.processes.contains(process)) {
                return;
            }
            process.addProcessModelListener(this.processListener);
            this.processes.add(process);
        }
        this.fireObjectsAdded(null, Arrays.asList(process));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProcessContextModel(ProcessContextModel process) {
        Object object = this.mutex;
        synchronized (object) {
            if (process == null || !this.processes.contains(process)) {
                return;
            }
            process.removeProcessModelListener(this.processListener);
            this.processes.remove(process);
        }
        this.fireObjectsRemoved(null, Arrays.asList(process));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ProcessContextModel[] getProcessModels() {
        Object object = this.mutex;
        synchronized (object) {
            return this.processes.toArray(new ProcessContextModel[this.processes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IProcessMessageContext[] getProcessContextMessages() {
        Object object = this.mutex;
        synchronized (object) {
            return this.messages.toArray(new IProcessMessageContext[this.messages.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProcessMessageListener(IProcessMessageListener listener) {
        List<IProcessMessageListener> list = this.processMessageListeners;
        synchronized (list) {
            this.processMessageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProcessMessageListener(IProcessMessageListener listener) {
        List<IProcessMessageListener> list = this.processMessageListeners;
        synchronized (list) {
            this.processMessageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireMessageAdded(IProcessMessageContext message) {
        ArrayList<IProcessMessageListener> listeners = new ArrayList<IProcessMessageListener>();
        List<IProcessMessageListener> list = this.processMessageListeners;
        synchronized (list) {
            listeners.addAll(this.processMessageListeners);
        }
        for (IProcessMessageListener listener : listeners) {
            listener.messageAdded(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireMessageRemoved(IProcessMessageContext message) {
        ArrayList<IProcessMessageListener> listeners = new ArrayList<IProcessMessageListener>();
        List<IProcessMessageListener> list = this.processMessageListeners;
        synchronized (list) {
            listeners.addAll(this.processMessageListeners);
        }
        for (IProcessMessageListener listener : listeners) {
            listener.messageRemoved(message);
        }
    }
}

