/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.swing.icon.GuiIconDecorator;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icon.IGuiIconDecoration;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.IProcessMessageListener;
import net.anwiba.commons.swing.process.ProcessContextModelListModel;
import net.anwiba.commons.swing.process.ProcessManagerDialog;
import net.anwiba.commons.swing.process.ProcessMessages;
import net.anwiba.commons.swing.ui.GuiIconDecoration;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.process.IProcessManager;

public final class OpenProcessManagerDialogAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Window owner;
    private MessageType messageState = MessageType.DEFAULT;
    final ProcessContextModelListModel processContextModelListModel;
    private ProcessManagerDialog dialog;
    private final IProcessManager manager;
    private final Object shemaphor = new Object();

    public OpenProcessManagerDialogAction(Window owner, IProcessManager manager, final ProcessContextModelListModel processContextModelListModel) {
        super(null, GuiIcons.TASKBAR_ICON.getSmallIcon());
        this.owner = owner;
        this.manager = manager;
        this.processContextModelListModel = processContextModelListModel;
        this.processContextModelListModel.addProcessMessageListener(new IProcessMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageAdded(IProcessMessageContext messageContext) {
                Object object = OpenProcessManagerDialogAction.this.shemaphor;
                synchronized (object) {
                    MessageType messageType = messageContext.getMessage().getMessageType();
                    if (messageType.ordinal() <= OpenProcessManagerDialogAction.this.getMessageState().ordinal()) {
                        return;
                    }
                    OpenProcessManagerDialogAction.this.update(messageType);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageRemoved(IProcessMessageContext messageContext) {
                Object object = OpenProcessManagerDialogAction.this.shemaphor;
                synchronized (object) {
                    MessageType messageType = OpenProcessManagerDialogAction.this.getCurrentMessageState(processContextModelListModel.getProcessContextMessages());
                    OpenProcessManagerDialogAction.this.update(messageType);
                }
            }
        });
        this.putValue("ShortDescription", ProcessMessages.PROCESS_MANAGER);
        MessageType messageType = this.getCurrentMessageState(processContextModelListModel.getProcessContextMessages());
        this.update(messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageState(MessageType messageType) {
        Object object = this.shemaphor;
        synchronized (object) {
            this.messageState = messageType;
        }
    }

    private Icon getDecoratedIcon(IGuiIcon guiIcon, GuiIconDecoration decoration) {
        return GuiIconDecorator.decorate((GuiIconSize)GuiIconSize.SMALL, (IGuiIcon)guiIcon, (IGuiIconDecoration)decoration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageType getCurrentMessageState(IProcessMessageContext[] processMessageContexts) {
        Object object = this.shemaphor;
        synchronized (object) {
            MessageType messageType = MessageType.DEFAULT;
            IProcessMessageContext[] iProcessMessageContextArray = processMessageContexts;
            int n = processMessageContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessMessageContext processMessageContext = iProcessMessageContextArray[n2];
                if (processMessageContext.getMessage().getMessageType().ordinal() > messageType.ordinal()) {
                    messageType = processMessageContext.getMessage().getMessageType();
                }
                ++n2;
            }
            return messageType;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = new ProcessManagerDialog(this.owner, this.manager, this.processContextModelListModel);
        }
        GuiUtilities.invokeLater(() -> {
            this.dialog.setVisible(true);
            this.dialog.toFront();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageType getMessageState() {
        Object object = this.shemaphor;
        synchronized (object) {
            return this.messageState;
        }
    }

    private void update(MessageType messageType) {
        this.setMessageState(messageType);
        GuiUtilities.invokeLater(() -> this.putValue("SmallIcon", this.getDecoratedIcon((IGuiIcon)GuiIcons.TASKBAR_ICON, GuiIconDecoration.getByMessageType((MessageType)messageType))));
    }
}

